package org.simantics.acorn.internal;

import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.cluster.ClusterImpl;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.service.ClusterUID;

public class ClusterUpdateProcessor extends ClusterUpdateProcessorBase {
	
	final ClusterSupport support;
	final ClusterUpdateOperation info;
	private ClusterImpl cluster;
	
	public ClusterUpdateProcessor(ClusterManager client, ClusterSupport support, byte[] operations, ClusterUpdateOperation info) throws DatabaseException {
		super(client, operations);
		this.support = support;
		this.info = info;
	}
	
	@Override
	void create() throws DatabaseException {
		cluster.createResource(support);
	}

	@Override
	void delete(int ri) throws DatabaseException {
		
		boolean oldValueEx = cluster.isValueEx(ri);
		byte[] old = cluster.getValue(ri, support);
		if(old != null) cluster.removeValue(ri, support);
		info.ccs.oldValueEx.add(oldValueEx ? (byte)1 : 0);
		info.ccs.oldValues.add(old);
		
	}

	@Override
	void modify(int resourceKey, long offset, int size, byte[] bytes, int pos)
			throws DatabaseException {
		
		cluster = (ClusterImpl)cluster.modiValueEx(resourceKey, offset, size, bytes, pos, support);
		manager.modiFileEx(cluster.getClusterUID(), resourceKey, offset, size, bytes, pos, support);
		
	}

	@Override
	void set(int resourceKey, byte[] bytes, int length)
			throws DatabaseException {
		
		byte[] old = cluster.getValue(resourceKey, support);
		boolean oldValueEx = cluster.isValueEx(resourceKey);
		cluster = (ClusterImpl)cluster.setValue(resourceKey, valueBuffer, length, support);
		info.ccs.oldValueEx.add(oldValueEx ? (byte)1 : 0);
		info.ccs.oldValues.add(old);
		
	}

	@Override
	void claim(int resourceKey, int predicateKey, int objectKey, ClusterUID puid, ClusterUID ouid)
			throws DatabaseException {
		
		ClusterImpl c = (ClusterImpl)cluster.addRelation(resourceKey, puid, predicateKey, ouid, objectKey, support);
		if(c != null) cluster = c;
		info.ccs.statementMask.add(c != null ? (byte)1 : 0);
		
	}

	@Override
	void deny(int resourceKey, int predicateKey, int objectKey, ClusterUID puid, ClusterUID ouid)
			throws DatabaseException {
		
		boolean modified = cluster.removeRelation(resourceKey, predicateKey, objectKey, support);
		info.ccs.statementMask.add(modified ? (byte)1 : 0);

	}

	@Override
	void setImmutable(boolean value) {
		cluster.setImmutable(value, support);
	}

	public ClusterImpl process(ClusterImpl cluster) throws IllegalAcornStateException {
		this.cluster = cluster;
		process();
		info.finish();
		return this.cluster;
	}

}
