package org.simantics.acorn;

import java.util.Collection;
import java.util.Properties;
import java.util.function.Consumer;

import org.simantics.db.Database;
import org.simantics.db.Driver.Management;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.service.ClusterUID;

public class AcornManagement implements Management {

    private final Database db;
    private final Properties properties;

    AcornManagement(Database db, Properties properties) throws ProCoreException {
        this.db = db;
        this.properties = properties;
    }

    @Override
    public boolean exist() throws DatabaseException {
        return db.isFolderOk();
    }

    @Override
    public void delete() throws DatabaseException {
        db.deleteFiles();
        if (exist())
            throw new DatabaseException("Failed to delete database. folder=" + db.getFolder());
    }

    @Override
    public void create() throws DatabaseException {
        db.initFolder(properties);
        if (!exist())
            throw new DatabaseException("Failed to create Acorn database. folder=" + db.getFolder());
    }

    @Override
    public void purge(Consumer<Collection<ClusterUID>> callback) throws DatabaseException {
        db.purgeDatabase(callback);
    }

    @Override
    public void shutdown() throws DatabaseException {
        db.tryToStop();
        db.disconnect();
    }

}
