package org.simantics.acorn.lru;

import java.util.concurrent.Semaphore;

import org.simantics.db.service.ClusterUID;

public class ClusterUpdateState {
	
	final ClusterUID uid;
	final Semaphore lock = new Semaphore(0);
	int referenceCount = 0;
	boolean inUpdate = false;
	
	ClusterUpdateState(ClusterUID uid) {
		this.uid = uid;
	}
	
	public void waitForUpdates() {
		try {
			lock.acquire();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	public synchronized void beginUpdate() {
//	    System.err.println("ClusterUpdateState.beginUpdate() for " + uid + ", inUpdate=" + inUpdate);
		assert(!inUpdate);
		inUpdate = true;
	}
	
	public synchronized void endUpdate() {
//	    System.err.println("ClusterUpdateState.endUpdate() for " + uid + ", inUpdate=" + inUpdate);
		assert(inUpdate);
		inUpdate = false;
	}
	
	public synchronized void incRef() {
		referenceCount++;
	}
	
	public synchronized ClusterUpdateState decRef() {
		referenceCount--;
		if(referenceCount == 0) {
			lock.release(Integer.MAX_VALUE);
			return null;
		}
		return this;
	}
	
}