package org.simantics.acorn.lru;

public class AccessTime {

	private long last = 0;
	
	private static AccessTime INSTANCE = new AccessTime();
	
	private AccessTime() {
		
	}
	
	public static AccessTime getInstance() {
		return INSTANCE;
	}
	
	public synchronized long getAccessTime() {
		long result = System.nanoTime();
		last = Math.max(result, last+1);
		return last;
	}
	
}
