package org.simantics.acorn;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class ExternalizableExample implements Externalizable {

    public int first;
    private long second;
    
    public ExternalizableExample(int first, long second) {
        this.first = first;
        this.second = second;
    }
    
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(first);
        out.writeLong(second);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        
    }

    
    public static void main(String[] args) {
        Externalizable test = new ExternalizableExample(123, 3456);
        
        try (ObjectOutputStream stream = new ObjectOutputStream(Files.newOutputStream(Paths.get("C:/Users/Jani Simomaa/Desktop/test"), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING))) {
            stream.writeObject(test);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
