package org.simantics.acorn;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

import org.simantics.acorn.internal.AcornDatabase;
import org.simantics.db.Database;
import org.simantics.db.server.ProCoreException;

/**
 * @author Tuukka Lehtonen
 */
public class AcornDatabaseManager {

    private static Map<String, Database> dbs = new HashMap<String, Database>();

    public static synchronized Database getDatabase(Path folder) throws ProCoreException {
        Path canonical;
        try {
            Files.createDirectories(folder);
            canonical = folder.toRealPath();
        } catch (IOException e) {
            throw new ProCoreException("Could not get canonical path.", e);
        }

        String canonicalPath = canonical.toString();
        Database db = dbs.get(canonicalPath);
        if (null != db)
            return db;

        db = new AcornDatabase(canonical);
        dbs.put(canonicalPath, db);
        return db;
    }

}