/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.simantics.Simantics;
import org.simantics.application.arguments.Arguments;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class SCLScriptRunnerApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        try {
            String[] args = (String[])context.getArguments().get("application.args");
            NullProgressMonitor progress = new NullProgressMonitor();
            Simantics.startUpHeadless((IArguments)this.parseArguments(args), (IProgressMonitor)progress);
            this.runSCLFromStdin();
            Simantics.shutdown((IProgressMonitor)progress);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw (Exception)t;
        }
        finally {
            System.exit(0);
        }
    }

    private void runSCLFromStdin() throws Exception {
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        CommandSession commandSession = new CommandSession(SCLOsgi.MODULE_REPOSITORY, SCLReportingHandler.DEFAULT_WITHOUT_ECHO);
        try {
            String line;
            while ((line = input.readLine()) != null) {
                if (line.isEmpty()) continue;
                commandSession.execute(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IArguments parseArguments(String[] args) {
        IArgumentFactory[] accepted = new IArgumentFactory[]{SimanticsArguments.RECOVERY_POLICY_FIX_ERRORS, SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL, SimanticsArguments.SERVER, SimanticsArguments.LOCAL_SERVER_PORT};
        IArguments result = Arguments.parse((String[])args, (IArgumentFactory[])accepted);
        return result;
    }

    public void stop() {
    }
}

