/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.editors.win32.ole;

import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.simantics.editors.win32.OLEEditorInput;
import org.simantics.editors.win32.ole.OleController;

public class WMPController
implements OleController {
    OleFrame frame;
    OleClientSite site;
    OleAutomation auto;

    public WMPController(OleFrame frame, OleClientSite site, OleAutomation auto) {
        this.frame = frame;
        this.site = site;
        this.auto = auto;
    }

    @Override
    public void show(OLEEditorInput input) {
        this.site.doVerb(-1);
        this.frame.setSize(240, 245);
        this.setUIMode("none");
        this.setStrechToFit(true);
        String url = "file:///" + input.getFile().getAbsoluteFile();
        url = url.replace('\\', '/');
        System.out.println(url);
        this.loadMedia(url);
        this.frame.layout();
        this.setUIMode("full");
    }

    public void setUIMode(String mode) {
        int[] ids = this.auto.getIDsOfNames(new String[]{"uiMode"});
        if (ids != null) {
            this.auto.setProperty(ids[0], new Variant(mode));
        }
    }

    public void setStrechToFit(boolean fit) {
        int[] ids = this.auto.getIDsOfNames(new String[]{"stretchToFit"});
        if (ids != null) {
            this.auto.setProperty(ids[0], new Variant(fit));
        }
    }

    public void loadMedia(String url) {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"URL"});
        if (rgdispid != null) {
            int dispIdMember = rgdispid[0];
            boolean b = this.auto.setProperty(dispIdMember, new Variant(url));
            System.out.println(b);
        }
    }

    public void play() {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"controls"});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return;
        }
        OleAutomation controls = pVarResult.getAutomation();
        rgdispid = controls.getIDsOfNames(new String[]{"play"});
        controls.invoke(rgdispid[0]);
        pVarResult.dispose();
        controls.dispose();
    }

    public void stop() {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"controls"});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() == 0) {
            return;
        }
        OleAutomation controls = pVarResult.getAutomation();
        rgdispid = controls.getIDsOfNames(new String[]{"stop"});
        controls.invoke(rgdispid[0]);
        pVarResult.dispose();
        controls.dispose();
    }

    public boolean setFullScreen(boolean mode) {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"fullScreen"});
        boolean result = this.auto.setProperty(rgdispid[0], new Variant(mode));
        return result;
    }

    public boolean setWindowlessVideo(boolean mode) {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"windowlessVideo"});
        boolean result = this.auto.setProperty(rgdispid[0], new Variant(mode));
        return result;
    }

    public String getStatus() {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"status"});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() != 8) {
            return "";
        }
        String result = pVarResult.getString();
        pVarResult.dispose();
        return result;
    }
}

