/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.editors.win32;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.editors.win32.OLEEditorInput;
import org.simantics.editors.win32.ole.EditorDefinition;
import org.simantics.editors.win32.ole.OleController;

public class OLEEditor
extends EditorPart {
    private OleFrame frame;
    private OleClientSite site;
    private OleAutomation auto;
    private OleController ctrl;
    private Shell fsShell;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof OLEEditorInput)) {
            throw new PartInitException("Input must be OLEEditorInput");
        }
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        OLEEditorInput input = (OLEEditorInput)this.getEditorInput();
        boolean fullscreen = input.isFullscreen();
        if (fullscreen) {
            this.fsShell = new Shell(parent.getDisplay());
            this.fsShell.setLayout((Layout)new GridLayout(1, false));
            this.fsShell.setLayout((Layout)new FillLayout());
            parent = new Composite((Composite)this.fsShell, 0);
            this.fsShell.open();
            this.fsShell.setFullScreen(true);
            parent.setLayout((Layout)new FillLayout());
        }
        EditorDefinition factory = input.getFactory();
        this.frame = new OleFrame(parent, 0);
        if (factory.getProgID() == null || factory.useFileInput()) {
            this.site = new OleClientSite((Composite)this.frame, 0, input.getFile());
        } else {
            this.site = new OleClientSite((Composite)this.frame, 0, factory.getProgID());
            this.auto = new OleAutomation(this.site);
            this.ctrl = factory.createController(this.frame, this.site, this.auto);
            this.ctrl.show(input);
        }
        this.setPartName(String.valueOf(this.site.getProgramID()) + " : " + input.getName());
        if (fullscreen) {
            this.fsShell.layout(true, true);
        }
    }

    public void setFocus() {
        this.frame.setFocus();
    }

    public OleController getController() {
        return this.ctrl;
    }

    public void dispose() {
        if (this.auto != null) {
            this.auto.dispose();
        }
        this.site.dispose();
        if (this.fsShell != null) {
            this.fsShell.dispose();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
        super.dispose();
    }
}

