/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.simantics.databoard.util.URIStringUtils;

public class URITest {
    private static final int COUNT = 1000000;
    private static final String TEST_STR = "http://www.simantics.org/Layer0-1.0/HasInverse/Inverse";

    public static void main(String[] args) {
        try {
            String s1 = URLEncoder.encode(TEST_STR, "UTF-8");
            String s2 = URIStringUtils.escape((String)TEST_STR);
            System.out.println("URLEncoder.encode(http://www.simantics.org/Layer0-1.0/HasInverse/Inverse): " + s1);
            System.out.println("URIStringUtils.escapeAll(http://www.simantics.org/Layer0-1.0/HasInverse/Inverse): " + s2);
            String ds1 = URLDecoder.decode(s1, "UTF-8");
            String ds2 = URIStringUtils.unescape((String)s2);
            System.out.println("ds1: " + ds1);
            System.out.println("ds2: " + ds2);
            String ds1x2 = URIStringUtils.unescape((String)s2);
            String ds2x1 = URLDecoder.decode(s1, "UTF-8");
            System.out.println("ds1x2: " + ds1x2);
            System.out.println("ds2x1: " + ds2x1);
            long start = System.nanoTime();
            int i = 0;
            while (i < 1000000) {
                String string = URLEncoder.encode(TEST_STR, "UTF-8");
                ++i;
            }
            long end = System.nanoTime();
            System.out.println("URLEncoder: " + (double)(end - start) * 1.0E-9);
            long start2 = System.nanoTime();
            int i2 = 0;
            while (i2 < 1000000) {
                String string = URIStringUtils.escape((String)TEST_STR);
                ++i2;
            }
            long end2 = System.nanoTime();
            System.out.println("URIStringUtils.escape: " + (double)(end2 - start2) * 1.0E-9);
            long start3 = System.nanoTime();
            int i3 = 0;
            while (i3 < 1000000) {
                String string = URLDecoder.decode(ds1, "UTF-8");
                ++i3;
            }
            long end3 = System.nanoTime();
            System.out.println("URLDecoder: " + (double)(end3 - start3) * 1.0E-9);
            long start4 = System.nanoTime();
            int i4 = 0;
            while (i4 < 1000000) {
                String string = URIStringUtils.unescape((String)ds2);
                ++i4;
            }
            long end4 = System.nanoTime();
            System.out.println("URIStringUtils.decode: " + (double)(end4 - start4) * 1.0E-9);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }
}

