/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ProcedureBarrier;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.layer0.Layer0;

public class EscapedChildMapOfResource
extends ResourceAsyncRead<Map<String, Resource>> {
    public EscapedChildMapOfResource(Resource resource) {
        super(resource);
    }

    public void perform(AsyncReadGraph g, final AsyncProcedure<Map<String, Resource>> procedure) {
        final Layer0 L0 = (Layer0)g.getService(Layer0.class);
        final ConcurrentHashMap map = new ConcurrentHashMap();
        final ProcedureBarrier barrier = new ProcedureBarrier(1);
        g.forEachObject(this.resource, L0.ConsistsOf, (AsyncMultiProcedure)new AsyncMultiProcedureAdapter<Resource>(){

            @Override
            public void execute(AsyncReadGraph g, final Resource child) {
                barrier.incrementAndGet();
                g.forPossibleRelatedValue(child, L0.HasName, WriteBindings.STRING, (AsyncProcedure)new AsyncProcedure<Object>(){

                    public void execute(AsyncReadGraph g, Object name) {
                        String escapedName;
                        if (name != null && map.put(escapedName = URIStringUtils.escape((String)((String)name)), child) != null) {
                            System.err.println(this + ": The database contains siblings with the same name " + escapedName + " (resource=" + EscapedChildMapOfResource.this.resource.getResourceId() + ").");
                        }
                        barrier.dec(g, procedure, map);
                    }

                    public void exception(AsyncReadGraph graph, Throwable t) {
                        barrier.dec(graph, procedure, t);
                    }
                });
            }

            @Override
            public void exception(AsyncReadGraph graph, Throwable t) {
                barrier.dec(graph, procedure, t);
            }

            @Override
            public void finished(AsyncReadGraph g) {
                barrier.dec(g, procedure, map);
            }
        });
    }
}

