/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class PropertyMapOfResource
extends ResourceRead<Map<String, Resource>> {
    public PropertyMapOfResource(Resource resource) {
        super(resource);
    }

    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection predicates = graph.getPredicates(this.resource);
        THashMap result = new THashMap(predicates.size());
        for (Resource predicate : predicates) {
            String escapedName;
            String name;
            if (!graph.isSubrelationOf(predicate, L0.HasProperty) || (name = (String)graph.getPossibleRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING)) == null || result.put((Object)(escapedName = URIStringUtils.escape((String)name)), (Object)predicate) == null) continue;
            System.err.println(this + ": The database contains siblings with the same name " + name + " (resource=$" + this.resource.getResourceId() + ").");
        }
        return result;
    }
}

