/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class IndexRoot
extends ResourceRead<Resource> {
    public IndexRoot(Resource resource) {
        super(resource);
    }

    public Resource perform(ReadGraph graph) throws DatabaseException {
        Resource parent;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(this.resource, L0.IndexRoot)) {
            return this.resource;
        }
        HashSet parents = new HashSet(graph.getObjects(this.resource, L0.IsOwnedBy));
        Resource resource = parent = parents.size() == 1 ? (Resource)parents.iterator().next() : null;
        if (this.resource.equals(parent)) {
            parent = null;
        }
        if (parent == null) {
            if (parents.size() > 1) {
                parent = graph.getPossibleObject(this.resource, L0.PartOf);
            }
            if (parent == null) {
                parent = graph.getPossibleObject(this.resource, L0.HasObjectInverse);
            }
            if (parent == null) {
                throw new DatabaseException("Index root was not found for " + NameUtils.getSafeName(graph, this.resource, true));
            }
        }
        try {
            return (Resource)graph.syncRequest((Read)new IndexRoot(parent));
        }
        catch (DatabaseException e) {
            throw new DatabaseException("Index root was not found for " + NameUtils.getSafeName(graph, this.resource, true));
        }
    }
}

