/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.ResourceSetGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;

public class DependentInstances3
extends ResourceRead<ResourceSetGraph> {
    private static final boolean DEBUG = false;
    private static ThreadLocal<THashMap<DependentInstances3, ResourceSetGraph>> workArea = new ThreadLocal();

    public DependentInstances3(Resource resource) {
        super(resource);
    }

    private static ResourceSetGraph test(DependentInstances3 instance) {
        THashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
        if (set == null) {
            return null;
        }
        return (ResourceSetGraph)set.get((Object)instance);
    }

    private void register(ResourceSetGraph result) {
        THashMap set = workArea.get();
        if (set == null) {
            set = new THashMap();
            workArea.set((THashMap<DependentInstances3, ResourceSetGraph>)set);
        }
        set.put((Object)this, (Object)result);
    }

    private void unregister() {
        THashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
        if (set != null) {
            set.remove((Object)this);
        }
    }

    public ResourceSetGraph perform(ReadGraph graph) throws DatabaseException {
        if (this.resource.equals(graph.getRootLibrary())) {
            return new ResourceSetGraph(graph, this.resource);
        }
        ResourceSetGraph result = DependentInstances3.test(this);
        if (result != null) {
            return result;
        }
        result = new ResourceSetGraph(graph, this.resource);
        this.register(result);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set objects = cs.createSet();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement dep : graph.getStatements(this.resource, L0.IsDependencyOf)) {
            Resource object;
            if (graph.isSubrelationOf(dep.getPredicate(), L0.HasPrevious) || graph.isImmutable(object = dep.getObject())) continue;
            objects.add(object);
        }
        for (Resource object : objects) {
            DependentInstances3 query = new DependentInstances3(object);
            ResourceSetGraph instances = DependentInstances3.test(query);
            if (instances == null) {
                instances = (ResourceSetGraph)graph.syncRequest((Read)query);
            }
            result.references.add(instances);
        }
        this.unregister();
        return result;
    }
}

