/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.impl.LongBindingDefault;
import org.simantics.databoard.binding.impl.StringBindingDefault;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.impl.LongSerializer;
import org.simantics.databoard.serialization.impl.ModifiedUTF8StringSerializer;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class WriteBindings {
    public static Binding STRING = STRING_BINDING.INSTANCE;
    public static Binding BYTE_ARRAY = BYTE_ARRAY_BINDING.INSTANCE;
    public static Binding LONG_ARRAY = LONG_ARRAY_BINDING.INSTANCE;
    public static Binding TRANSFERABLE_GRAPH = TRANSFERABLE_GRAPH_BINDING.INSTANCE;

    public static void main(String[] args) {
        TransferableGraph1 tg = new TransferableGraph1(123, new Identity[]{new Identity(11, (IdentityDefinition)new Root("foo", "bar1")), new Identity(12, (IdentityDefinition)new External(21, "bar2")), new Identity(13, (IdentityDefinition)new Internal(22, "bar3")), new Identity(14, (IdentityDefinition)new Optional(23, "bar4"))}, new int[]{1, 2, 3}, new Value[]{new Value(31, new Variant((Binding)Bindings.INTEGER, (Object)123))});
        try {
            System.err.println(Arrays.toString(Bindings.getSerializerUnchecked((Binding)Bindings.getBinding(TransferableGraph1.class)).serialize((Object)tg)));
            System.err.println(Arrays.toString(TRANSFERABLE_GRAPH_SERIALIZER.INSTANCE.serialize(tg)));
        }
        catch (RuntimeSerializerConstructionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BindingConstructionException e) {
            e.printStackTrace();
        }
    }

    static class BYTE_ARRAY_BINDING
    extends LongBindingDefault {
        public static BYTE_ARRAY_BINDING INSTANCE = new BYTE_ARRAY_BINDING();

        public BYTE_ARRAY_BINDING() {
            super(Datatypes.LONG);
        }

        public Serializer serializer() throws RuntimeSerializerConstructionException {
            return BYTE_ARRAY_SERIALIZER.INSTANCE;
        }

        public boolean isInstance(Object obj) {
            return obj instanceof byte[];
        }
    }

    static class BYTE_ARRAY_SERIALIZER
    extends LongSerializer {
        public static BYTE_ARRAY_SERIALIZER INSTANCE = new BYTE_ARRAY_SERIALIZER();

        public BYTE_ARRAY_SERIALIZER() {
            super((LongBinding)BYTE_ARRAY_BINDING.INSTANCE);
        }

        public byte[] serialize(Object obj) throws IOException {
            return (byte[])obj;
        }

        public Object deserialize(byte[] data) throws IOException {
            return data;
        }
    }

    static class LONG_ARRAY_BINDING
    extends LongBindingDefault {
        public static LONG_ARRAY_BINDING INSTANCE = new LONG_ARRAY_BINDING();

        public LONG_ARRAY_BINDING() {
            super(Datatypes.LONG);
        }

        public Serializer serializer() throws RuntimeSerializerConstructionException {
            return LONG_ARRAY_SERIALIZER.INSTANCE;
        }
    }

    static final class LONG_ARRAY_SERIALIZER
    extends LongSerializer {
        public static LONG_ARRAY_SERIALIZER INSTANCE = new LONG_ARRAY_SERIALIZER();

        public LONG_ARRAY_SERIALIZER() {
            super((LongBinding)LONG_ARRAY_BINDING.INSTANCE);
        }

        private final void loop(byte[] result, int index, long l) {
            result[index + 7] = (byte)l;
            result[index + 6] = (byte)(l >>>= 8);
            result[index + 5] = (byte)(l >>>= 8);
            result[index + 4] = (byte)(l >>>= 8);
            result[index + 3] = (byte)(l >>>= 8);
            result[index + 2] = (byte)(l >>>= 8);
            result[index + 1] = (byte)(l >>>= 8);
            result[index] = (byte)(l >>>= 8);
            l >>>= 8;
        }

        public byte[] serialize(Object obj) throws IOException {
            long[] data = (long[])obj;
            byte[] result = new byte[4 + 8 * data.length];
            int len = data.length;
            result[3] = (byte)(len & 0xFF);
            result[2] = (byte)((len >>>= 8) & 0xFF);
            result[1] = (byte)((len >>>= 8) & 0xFF);
            result[0] = (byte)((len >>>= 8) & 0xFF);
            int index = 4;
            int i = 0;
            while (i < data.length) {
                this.loop(result, index, data[i]);
                index += 8;
                ++i;
            }
            return result;
        }
    }

    static class STRING_BINDING
    extends StringBindingDefault {
        public static STRING_BINDING INSTANCE = new STRING_BINDING();

        public STRING_BINDING() {
            super(Datatypes.STRING);
        }

        public Serializer serializer() throws RuntimeSerializerConstructionException {
            return STRING_SERIALIZER.INSTANCE;
        }

        public boolean isInstance(Object obj) {
            return obj instanceof String;
        }
    }

    static class STRING_SERIALIZER
    extends ModifiedUTF8StringSerializer {
        public static final Charset UTF8 = Charset.forName("utf-8");
        public static STRING_SERIALIZER INSTANCE = new STRING_SERIALIZER();

        public STRING_SERIALIZER() {
            super((StringBinding)STRING_BINDING.INSTANCE);
        }

        static byte[] writeUTF(String str) throws IOException {
            byte[] bytearr;
            char c;
            int strlen = str.length();
            int utflen = 0;
            int i = 0;
            while (i < strlen) {
                c = str.charAt(i);
                utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
                ++i;
            }
            if (utflen > 65535) {
                throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
            }
            int byteIndex = 0;
            if (utflen < 128) {
                bytearr = new byte[utflen + 1];
                bytearr[byteIndex++] = (byte)utflen;
            } else if ((utflen -= 128) < 16384) {
                bytearr = new byte[utflen + 2];
                bytearr[byteIndex++] = (byte)(utflen & 0x3F | 0x80);
                bytearr[byteIndex++] = (byte)(utflen >>> 6);
            } else if ((utflen -= 16384) < 0x200000) {
                bytearr = new byte[utflen + 3];
                bytearr[byteIndex++] = (byte)(utflen & 0x1F | 0xC0);
                bytearr[byteIndex++] = (byte)(utflen >>> 5 & 0xFF);
                bytearr[byteIndex++] = (byte)(utflen >>> 13 & 0xFF);
            } else if ((utflen -= 0x200000) < 0x10000000) {
                bytearr = new byte[utflen + 4];
                bytearr[byteIndex++] = (byte)(utflen & 0xF | 0xE0);
                bytearr[byteIndex++] = (byte)(utflen >>> 4 & 0xFF);
                bytearr[byteIndex++] = (byte)(utflen >>> 12 & 0xFF);
                bytearr[byteIndex++] = (byte)(utflen >>> 20 & 0xFF);
            } else {
                bytearr = new byte[(utflen -= 0x10000000) + 5];
                bytearr[byteIndex++] = (byte)(utflen & 7 | 0xF0);
                bytearr[byteIndex++] = (byte)(utflen >>> 3 & 0xFF);
                bytearr[byteIndex++] = (byte)(utflen >>> 11 & 0xFF);
                bytearr[byteIndex++] = (byte)(utflen >>> 19 & 0xFF);
                bytearr[byteIndex++] = (byte)(utflen >>> 27 & 0xFF);
            }
            int i2 = 0;
            i2 = 0;
            while (i2 < strlen) {
                c = str.charAt(i2);
                if (c < '\u0001' || c > '\u007f') break;
                bytearr[byteIndex++] = (byte)c;
                ++i2;
            }
            while (i2 < strlen) {
                c = str.charAt(i2);
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[byteIndex++] = (byte)c;
                } else if (c > '\u07ff') {
                    bytearr[byteIndex++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[byteIndex++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[byteIndex++] = (byte)(0x80 | c >> 0 & 0x3F);
                } else {
                    bytearr[byteIndex++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    bytearr[byteIndex++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                ++i2;
            }
            return bytearr;
        }

        public byte[] serialize(Object obj) throws IOException {
            try {
                return STRING_SERIALIZER.writeUTF((String)obj);
            }
            catch (IOException e) {
                throw new SerializationException();
            }
        }
    }

    static class TRANSFERABLE_GRAPH_BINDING
    extends LongBindingDefault {
        public static TRANSFERABLE_GRAPH_BINDING INSTANCE = new TRANSFERABLE_GRAPH_BINDING();

        public TRANSFERABLE_GRAPH_BINDING() {
            super(Datatypes.LONG);
        }

        public Serializer serializer() throws RuntimeSerializerConstructionException {
            return TRANSFERABLE_GRAPH_SERIALIZER.INSTANCE;
        }
    }

    static class TRANSFERABLE_GRAPH_SERIALIZER
    extends LongSerializer {
        public static TRANSFERABLE_GRAPH_SERIALIZER INSTANCE = new TRANSFERABLE_GRAPH_SERIALIZER();

        public TRANSFERABLE_GRAPH_SERIALIZER() {
            super((LongBinding)TRANSFERABLE_GRAPH_BINDING.INSTANCE);
        }

        static int writeUTF(String str, byte[] bytearr, int byteIndex) throws IOException {
            char c;
            int strlen = str.length();
            int utflen = 0;
            int count = byteIndex;
            int i = 0;
            while (i < strlen) {
                c = str.charAt(i);
                utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
                ++i;
            }
            if (utflen > 65535) {
                throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
            }
            if (utflen < 128) {
                bytearr[count++] = (byte)utflen;
            } else if ((utflen -= 128) < 16384) {
                bytearr[count++] = (byte)(utflen & 0x3F | 0x80);
                bytearr[count++] = (byte)(utflen >>> 6);
            } else if ((utflen -= 16384) < 0x200000) {
                bytearr[count++] = (byte)(utflen & 0x1F | 0xC0);
                bytearr[count++] = (byte)(utflen >>> 5 & 0xFF);
                bytearr[count++] = (byte)(utflen >>> 13 & 0xFF);
            } else if ((utflen -= 0x200000) < 0x10000000) {
                bytearr[count++] = (byte)(utflen & 0xF | 0xE0);
                bytearr[count++] = (byte)(utflen >>> 4 & 0xFF);
                bytearr[count++] = (byte)(utflen >>> 12 & 0xFF);
                bytearr[count++] = (byte)(utflen >>> 20 & 0xFF);
            } else {
                bytearr[count++] = (byte)((utflen -= 0x10000000) & 7 | 0xF0);
                bytearr[count++] = (byte)(utflen >>> 3 & 0xFF);
                bytearr[count++] = (byte)(utflen >>> 11 & 0xFF);
                bytearr[count++] = (byte)(utflen >>> 19 & 0xFF);
                bytearr[count++] = (byte)(utflen >>> 27 & 0xFF);
            }
            i = 0;
            i = 0;
            while (i < strlen) {
                c = str.charAt(i);
                if (c < '\u0001' || c > '\u007f') break;
                bytearr[count++] = (byte)c;
                ++i;
            }
            while (i < strlen) {
                c = str.charAt(i);
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[count++] = (byte)c;
                } else if (c > '\u07ff') {
                    bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                } else {
                    bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                ++i;
            }
            return count - byteIndex;
        }

        public byte[] serialize(Object obj) throws IOException {
            TransferableGraph1 tg = (TransferableGraph1)obj;
            return Bindings.getSerializerUnchecked(TransferableGraph1.class).serialize((Object)tg);
        }

        private final String utf(byte[] bytes) {
            int length;
            char[] chars = new char[bytes.length];
            int index = 0;
            if ((length = bytes[index++] & 0xFF) >= 128) {
                if (length >= 192) {
                    if (length >= 224) {
                        if (length >= 240) {
                            length &= 0xF;
                            length += (bytes[index++] & 0xFF) << 3;
                            length += (bytes[index++] & 0xFF) << 11;
                            length += (bytes[index++] & 0xFF) << 19;
                            length += 270549120;
                        } else {
                            length &= 0x1F;
                            length += (bytes[index++] & 0xFF) << 4;
                            length += (bytes[index++] & 0xFF) << 12;
                            length += (bytes[index++] & 0xFF) << 20;
                            length += 2113664;
                        }
                    } else {
                        length &= 0x3F;
                        length += (bytes[index++] & 0xFF) << 5;
                        length += (bytes[index++] & 0xFF) << 13;
                        length += 16512;
                    }
                } else {
                    length &= 0x7F;
                    length += (bytes[index++] & 0xFF) << 6;
                    length += 128;
                }
            }
            int i = 0;
            int target = length + index;
            while (index < target) {
                int c2;
                int c;
                if ((c = bytes[index++] & 0xFF) <= 127) {
                    chars[i++] = (char)(c & 0x7F);
                    continue;
                }
                if (c > 2047) {
                    c2 = bytes[index++] & 0xFF;
                    int c3 = bytes[index++] & 0xFF;
                    chars[i++] = (char)(((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F));
                    continue;
                }
                c2 = bytes[index++] & 0xFF;
                chars[i++] = (char)(((c & 0x1F) << 6) + (c2 & 0x3F));
            }
            return new String(chars, 0, i);
        }

        public Object deserialize(byte[] data) throws IOException {
            return this.utf(data);
        }
    }
}

