/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm5.xml;

import org.objectweb.asm5.AnnotationVisitor;
import org.objectweb.asm5.Type;
import org.objectweb.asm5.TypePath;
import org.objectweb.asm5.xml.SAXAdapter;
import org.objectweb.asm5.xml.SAXClassAdapter;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXAnnotationAdapter
extends AnnotationVisitor {
    SAXAdapter sa;
    private final String elementName;

    public SAXAnnotationAdapter(SAXAdapter sa, String elementName, int visible, String name, String desc) {
        this(327680, sa, elementName, visible, desc, name, -1, -1, null, null, null, null);
    }

    public SAXAnnotationAdapter(SAXAdapter sa, String elementName, int visible, int parameter, String desc) {
        this(327680, sa, elementName, visible, desc, null, parameter, -1, null, null, null, null);
    }

    public SAXAnnotationAdapter(SAXAdapter sa, String elementName, int visible, String name, String desc, int typeRef, TypePath typePath) {
        this(327680, sa, elementName, visible, desc, name, -1, typeRef, typePath, null, null, null);
    }

    public SAXAnnotationAdapter(SAXAdapter sa, String elementName, int visible, String name, String desc, int typeRef, TypePath typePath, String[] start, String[] end, int[] index) {
        this(327680, sa, elementName, visible, desc, name, -1, typeRef, typePath, start, end, index);
    }

    protected SAXAnnotationAdapter(int api, SAXAdapter sa, String elementName, int visible, String desc, String name, int parameter) {
        this(api, sa, elementName, visible, desc, name, parameter, -1, null, null, null, null);
    }

    protected SAXAnnotationAdapter(int api, SAXAdapter sa, String elementName, int visible, String desc, String name, int parameter, int typeRef, TypePath typePath, String[] start, String[] end, int[] index) {
        super(api);
        int i;
        StringBuffer value;
        this.sa = sa;
        this.elementName = elementName;
        AttributesImpl att = new AttributesImpl();
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (visible != 0) {
            att.addAttribute("", "visible", "visible", "", visible > 0 ? "true" : "false");
        }
        if (parameter != -1) {
            att.addAttribute("", "parameter", "parameter", "", Integer.toString(parameter));
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        if (typeRef != -1) {
            att.addAttribute("", "typeRef", "typeRef", "", Integer.toString(typeRef));
        }
        if (typePath != null) {
            att.addAttribute("", "typePath", "typePath", "", typePath.toString());
        }
        if (start != null) {
            value = new StringBuffer(start[0]);
            i = 1;
            while (i < start.length) {
                value.append(" ").append(start[i]);
                ++i;
            }
            att.addAttribute("", "start", "start", "", value.toString());
        }
        if (end != null) {
            value = new StringBuffer(end[0]);
            i = 1;
            while (i < end.length) {
                value.append(" ").append(end[i]);
                ++i;
            }
            att.addAttribute("", "end", "end", "", value.toString());
        }
        if (index != null) {
            value = new StringBuffer();
            value.append(index[0]);
            i = 1;
            while (i < index.length) {
                value.append(" ").append(index[i]);
                ++i;
            }
            att.addAttribute("", "index", "index", "", value.toString());
        }
        sa.addStart(elementName, att);
    }

    @Override
    public void visit(String name, Object value) {
        Class<?> c = value.getClass();
        if (c.isArray()) {
            AnnotationVisitor av = this.visitArray(name);
            if (value instanceof byte[]) {
                byte[] b = (byte[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            } else if (value instanceof char[]) {
                char[] b = (char[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, Character.valueOf(b[i]));
                    ++i;
                }
            } else if (value instanceof short[]) {
                short[] b = (short[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            } else if (value instanceof boolean[]) {
                boolean[] b = (boolean[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            } else if (value instanceof int[]) {
                int[] b = (int[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            } else if (value instanceof long[]) {
                long[] b = (long[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            } else if (value instanceof float[]) {
                float[] b = (float[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, Float.valueOf(b[i]));
                    ++i;
                }
            } else if (value instanceof double[]) {
                double[] b = (double[])value;
                int i = 0;
                while (i < b.length) {
                    av.visit(null, b[i]);
                    ++i;
                }
            }
            av.visitEnd();
        } else {
            this.addValueElement("annotationValue", name, Type.getDescriptor(c), value.toString());
        }
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.addValueElement("annotationValueEnum", name, desc, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return new SAXAnnotationAdapter(this.sa, "annotationValueAnnotation", 0, name, desc);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        return new SAXAnnotationAdapter(this.sa, "annotationValueArray", 0, name, null);
    }

    @Override
    public void visitEnd() {
        this.sa.addEnd(this.elementName);
    }

    private void addValueElement(String element, String name, String desc, String value) {
        AttributesImpl att = new AttributesImpl();
        if (name != null) {
            att.addAttribute("", "name", "name", "", name);
        }
        if (desc != null) {
            att.addAttribute("", "desc", "desc", "", desc);
        }
        if (value != null) {
            att.addAttribute("", "value", "value", "", SAXClassAdapter.encode(value));
        }
        this.sa.addElement(element, att);
    }
}

