/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm5.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm5.tree.JumpInsnNode;
import org.objectweb.asm5.tree.LabelNode;
import org.objectweb.asm5.tree.analysis.AnalyzerException;

class Subroutine {
    LabelNode start;
    boolean[] access;
    List<JumpInsnNode> callers;

    private Subroutine() {
    }

    Subroutine(LabelNode start, int maxLocals, JumpInsnNode caller) {
        this.start = start;
        this.access = new boolean[maxLocals];
        this.callers = new ArrayList<JumpInsnNode>();
        this.callers.add(caller);
    }

    public Subroutine copy() {
        Subroutine result = new Subroutine();
        result.start = this.start;
        result.access = new boolean[this.access.length];
        System.arraycopy(this.access, 0, result.access, 0, this.access.length);
        result.callers = new ArrayList<JumpInsnNode>(this.callers);
        return result;
    }

    public boolean merge(Subroutine subroutine) throws AnalyzerException {
        boolean changes = false;
        int i = 0;
        while (i < this.access.length) {
            if (subroutine.access[i] && !this.access[i]) {
                this.access[i] = true;
                changes = true;
            }
            ++i;
        }
        if (subroutine.start == this.start) {
            i = 0;
            while (i < subroutine.callers.size()) {
                JumpInsnNode caller = subroutine.callers.get(i);
                if (!this.callers.contains(caller)) {
                    this.callers.add(caller);
                    changes = true;
                }
                ++i;
            }
        }
        return changes;
    }
}

