/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm5.optimizer;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.objectweb.asm5.Type;

public class NameMapping {
    public final Properties mapping = new Properties();
    public final Set<Object> unused;

    public NameMapping(String file) throws IOException {
        try (InputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(file));
            this.mapping.load(is);
            this.unused = new HashSet<Object>(this.mapping.keySet());
        }
    }

    public String map(String name) {
        String s = (String)this.mapping.get(name);
        if (s == null) {
            int q;
            int p = name.indexOf(46);
            s = p == -1 ? name : ((q = name.indexOf(40)) == -1 ? name.substring(p + 1) : name.substring(p + 1, q));
        } else {
            this.unused.remove(name);
        }
        return s;
    }

    public String fix(String desc) {
        if (desc.startsWith("(")) {
            Type[] arguments = Type.getArgumentTypes(desc);
            Type result = Type.getReturnType(desc);
            int i = 0;
            while (i < arguments.length) {
                arguments[i] = this.fix(arguments[i]);
                ++i;
            }
            result = this.fix(result);
            return Type.getMethodDescriptor(result, arguments);
        }
        return this.fix(Type.getType(desc)).getDescriptor();
    }

    private Type fix(Type t) {
        if (t.getSort() == 10) {
            return Type.getObjectType(this.map(t.getInternalName()));
        }
        if (t.getSort() == 9) {
            String s = this.fix(t.getElementType()).getDescriptor();
            int i = 0;
            while (i < t.getDimensions()) {
                s = String.valueOf('[') + s;
                ++i;
            }
            return Type.getType(s);
        }
        return t;
    }
}

