/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm5.optimizer;

import java.util.HashMap;
import org.objectweb.asm5.AnnotationVisitor;
import org.objectweb.asm5.Attribute;
import org.objectweb.asm5.FieldVisitor;
import org.objectweb.asm5.Label;
import org.objectweb.asm5.MethodVisitor;
import org.objectweb.asm5.Opcodes;
import org.objectweb.asm5.Type;
import org.objectweb.asm5.TypePath;
import org.objectweb.asm5.commons.Remapper;
import org.objectweb.asm5.commons.RemappingMethodAdapter;
import org.objectweb.asm5.optimizer.ClassOptimizer;

public class MethodOptimizer
extends RemappingMethodAdapter
implements Opcodes {
    private final ClassOptimizer classOptimizer;
    private static final HashMap<String, String[]> BOXING_MAP;

    static {
        String[][] boxingNames = new String[][]{{"java/lang/Byte", "(B)V"}, {"java/lang/Short", "(S)V"}, {"java/lang/Character", "(C)V"}, {"java/lang/Integer", "(I)V"}, {"java/lang/Long", "(J)V"}, {"java/lang/Float", "(F)V"}, {"java/lang/Double", "(D)V"}};
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[][] stringArrayArray = boxingNames;
        int n = boxingNames.length;
        int n2 = 0;
        while (n2 < n) {
            String[] boxingName = stringArrayArray[n2];
            String wrapper = boxingName[0];
            String desc = boxingName[1];
            String boxingMethod = String.valueOf(wrapper) + '(' + desc.charAt(1) + ")L" + wrapper + ';';
            map.put(boxingMethod, boxingName);
            ++n2;
        }
        BOXING_MAP = map;
    }

    public MethodOptimizer(ClassOptimizer classOptimizer, int access, String desc, MethodVisitor mv, Remapper remapper) {
        super(327680, access, desc, mv, remapper);
        this.classOptimizer = classOptimizer;
    }

    @Override
    public void visitParameter(String name, int access) {
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    @Override
    public void visitFrame(int type, int local, Object[] local2, int stack, Object[] stack2) {
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (!(cst instanceof Type)) {
            super.visitLdcInsn(cst);
            return;
        }
        String ldcName = ((Type)cst).getInternalName();
        String fieldName = "class$" + ldcName.replace('/', '$');
        if (!this.classOptimizer.syntheticClassFields.contains(ldcName)) {
            this.classOptimizer.syntheticClassFields.add(ldcName);
            FieldVisitor fv = this.classOptimizer.syntheticFieldVisitor(4104, fieldName, "Ljava/lang/Class;");
            fv.visitEnd();
        }
        String clsName = this.classOptimizer.clsName;
        this.mv.visitFieldInsn(178, clsName, fieldName, "Ljava/lang/Class;");
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        String[] constructorParams;
        if (opcode == 184 && name.equals("valueOf") && (constructorParams = BOXING_MAP.get(String.valueOf(owner) + desc)) != null) {
            String type = constructorParams[0];
            String initDesc = constructorParams[1];
            super.visitTypeInsn(187, type);
            super.visitInsn(89);
            super.visitInsn(initDesc == "(J)V" || initDesc == "(D)V" ? 94 : 93);
            super.visitInsn(88);
            super.visitMethodInsn(183, type, "<init>", initDesc, false);
            return;
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }
}

