/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm5.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm5.AnnotationVisitor;
import org.objectweb.asm5.Attribute;
import org.objectweb.asm5.ClassVisitor;
import org.objectweb.asm5.FieldVisitor;
import org.objectweb.asm5.Label;
import org.objectweb.asm5.MethodVisitor;
import org.objectweb.asm5.TypePath;
import org.objectweb.asm5.commons.Remapper;
import org.objectweb.asm5.commons.RemappingClassAdapter;
import org.objectweb.asm5.optimizer.MethodOptimizer;

public class ClassOptimizer
extends RemappingClassAdapter {
    private String pkgName;
    String clsName;
    boolean isInterface = false;
    boolean hasClinitMethod = false;
    List<String> syntheticClassFields = new ArrayList<String>();

    public ClassOptimizer(ClassVisitor cv, Remapper remapper) {
        super(327680, cv, remapper);
    }

    FieldVisitor syntheticFieldVisitor(int access, String name, String desc) {
        return super.visitField(access, name, desc, null, null);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(46, access, name, null, superName, interfaces);
        int index = name.lastIndexOf(47);
        this.pkgName = index > 0 ? name.substring(0, index) : "";
        this.clsName = name;
        this.isInterface = (access & 0x200) != 0;
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        String s = this.remapper.mapFieldName(this.className, name, desc);
        if ("-".equals(s)) {
            return null;
        }
        if ((access & 5) == 0) {
            if ((access & 0x10) != 0 && (access & 8) != 0 && desc.length() == 1) {
                return null;
            }
            if ("org/objectweb/asm".equals(this.pkgName) && s.equals(name)) {
                System.out.println("INFO: " + this.clsName + "." + s + " could be renamed");
            }
            super.visitField(access, name, desc, null, value);
        } else {
            if (!s.equals(name)) {
                throw new RuntimeException("The public or protected field " + this.className + '.' + name + " must not be renamed.");
            }
            super.visitField(access, name, desc, null, value);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String s = this.remapper.mapMethodName(this.className, name, desc);
        if ("-".equals(s)) {
            return null;
        }
        if (name.equals("<clinit>") && !this.isInterface) {
            this.hasClinitMethod = true;
            MethodVisitor mv = super.visitMethod(access, name, desc, null, exceptions);
            return new MethodVisitor(327680, mv){

                @Override
                public void visitCode() {
                    super.visitCode();
                    this.mv.visitMethodInsn(184, ClassOptimizer.this.clsName, "_clinit_", "()V", false);
                }
            };
        }
        if ((access & 5) == 0) {
            if ("org/objectweb/asm".equals(this.pkgName) && !name.startsWith("<") && s.equals(name)) {
                System.out.println("INFO: " + this.clsName + "." + s + " could be renamed");
            }
            return super.visitMethod(access, name, desc, null, exceptions);
        }
        if (!s.equals(name)) {
            throw new RuntimeException("The public or protected method " + this.className + '.' + name + desc + " must not be renamed.");
        }
        return super.visitMethod(access, name, desc, null, exceptions);
    }

    @Override
    protected MethodVisitor createRemappingMethodAdapter(int access, String newDesc, MethodVisitor mv) {
        return new MethodOptimizer(this, access, newDesc, mv, this.remapper);
    }

    @Override
    public void visitEnd() {
        if (this.syntheticClassFields.isEmpty()) {
            if (this.hasClinitMethod) {
                MethodVisitor mv = this.cv.visitMethod(4104, "_clinit_", "()V", null, null);
                mv.visitCode();
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        } else {
            MethodVisitor mv = this.cv.visitMethod(4104, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", null, null);
            mv.visitCode();
            Label l0 = new Label();
            Label l1 = new Label();
            Label l2 = new Label();
            mv.visitTryCatchBlock(l0, l1, l2, "java/lang/ClassNotFoundException");
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            mv.visitLabel(l1);
            mv.visitInsn(176);
            mv.visitLabel(l2);
            mv.visitMethodInsn(182, "java/lang/ClassNotFoundException", "getMessage", "()Ljava/lang/String;", false);
            mv.visitVarInsn(58, 1);
            mv.visitTypeInsn(187, "java/lang/NoClassDefFoundError");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            mv.visitMaxs(3, 2);
            mv.visitEnd();
            mv = this.hasClinitMethod ? this.cv.visitMethod(10, "_clinit_", "()V", null, null) : this.cv.visitMethod(8, "<clinit>", "()V", null, null);
            for (String ldcName : this.syntheticClassFields) {
                String fieldName = "class$" + ldcName.replace('/', '$');
                mv.visitLdcInsn(ldcName.replace('/', '.'));
                mv.visitMethodInsn(184, this.clsName, "class$", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                mv.visitFieldInsn(179, this.clsName, fieldName, "Ljava/lang/Class;");
            }
            mv.visitInsn(177);
            mv.visitMaxs(1, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }
}

