/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.node.AAddressValue;
import org.simantics.basicexpression.node.AConstantValue;
import org.simantics.basicexpression.node.AFunctionPrimary;
import org.simantics.basicexpression.node.AMultMultiplicative;
import org.simantics.basicexpression.node.APlusExpression;
import org.simantics.basicexpression.node.ARangeValue;
import org.simantics.basicexpression.node.ARviValue;
import org.simantics.basicexpression.node.ASequenceArgList;
import org.simantics.basicexpression.node.ASingleArgList;
import org.simantics.basicexpression.node.ASingleRange;
import org.simantics.basicexpression.node.AStringValue;
import org.simantics.basicexpression.node.AVariablePrimary;
import org.simantics.basicexpression.node.PArgList;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Function;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class SpreadsheetExpressionVisitor
extends DepthFirstAdapter {
    public static final boolean DEBUG_APPLICATION = false;
    public static final boolean DEBUG = false;
    final ReadGraph graph;
    final Variable cellVariable;
    final Resource model;
    final Resource sheet;
    final int row;
    final int column;
    Stack<Object> stack = new Stack();
    HashMap<String, Function> builtins = new HashMap();

    public SpreadsheetExpressionVisitor(ReadGraph graph, Variable cellVariable, int row, int column) throws DatabaseException {
        this.graph = graph;
        this.cellVariable = cellVariable;
        this.model = Variables.getModel((ReadGraph)graph, (Variable)cellVariable);
        Resource cell = (Resource)cellVariable.getPossiblePropertyValue(graph, "Resource");
        this.sheet = graph.getPossibleObject(cell, Layer0.getInstance((ReadGraph)graph).PartOf);
        this.row = row;
        this.column = column;
    }

    public Object getResult() {
        return this.stack.pop();
    }

    public void outAConstantValue(AConstantValue node) {
        this.stack.push(Double.valueOf(node.toString()));
    }

    public void outAStringValue(AStringValue node) {
        String value = node.toString();
        this.stack.push(value.substring(1, value.length() - 2).trim());
    }

    public void outAAddressValue(AAddressValue node) {
        this.stack.push(String.valueOf('&') + node.getRange().toString());
    }

    public void outASingleRange(ASingleRange node) {
    }

    public void outARviValue(ARviValue node) {
        String rvi = node.toString().trim();
        try {
            System.out.println("browsing at " + this.cellVariable.getURI(this.graph));
            Variable var = this.cellVariable.browse(this.graph, rvi);
            this.stack.push(var);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void outAVariablePrimary(AVariablePrimary node) {
        String identifier = node.toString().trim();
        Range range = SpreadsheetUtils.decodeRange((String)identifier, (int)this.row, (int)this.column);
        if (range.size() != 1) {
            ArrayList<String> value = new ArrayList<String>();
            int c = range.startColumn;
            while (c <= range.endColumn) {
                int r = range.startRow;
                while (r <= range.endRow) {
                    try {
                        String location = SpreadsheetUtils.cellName((int)r, (int)c);
                        Variable cell = this.cellVariable.getChild(this.graph, location);
                        System.out.println("cell=" + cell.getURI(this.graph));
                        String label = (String)cell.getPossiblePropertyValue(this.graph, "Label");
                        System.out.println("lavel=" + label);
                        value.add(label);
                    }
                    catch (DatabaseException e) {
                        value.add(null);
                    }
                    ++r;
                }
                ++c;
            }
            this.stack.push(value);
            return;
        }
    }

    public void outARangeValue(ARangeValue node) {
        String identifier = node.getRange().toString().trim();
    }

    private double extractValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        return Double.NaN;
    }

    public void outAPlusExpression(APlusExpression node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        double d1 = this.extractValue(o1);
        double d2 = this.extractValue(o2);
        this.stack.push(d1 + d2);
    }

    public void outAMultMultiplicative(AMultMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        double d1 = this.extractValue(o1);
        double d2 = this.extractValue(o2);
        this.stack.push(d1 * d2);
    }

    int countArguments(PArgList args) {
        if (args == null) {
            return 0;
        }
        if (args instanceof ASingleArgList) {
            return 1;
        }
        ASequenceArgList seq = (ASequenceArgList)args;
        return 1 + this.countArguments(seq.getArgList());
    }

    public void outAFunctionPrimary(AFunctionPrimary node) {
        try {
            String functionName = node.getFunc().getText().replace("(", "");
            Function function = this.builtins.get(functionName);
            if (function != null) {
                LinkedList<Object> args = new LinkedList<Object>();
                int argc = this.countArguments(node.getArgList());
                int i = 0;
                while (i < argc) {
                    args.addFirst(this.stack.pop());
                    ++i;
                }
                args.addFirst(this.sheet);
                args.addFirst(this.model);
                Object result = function.apply((RequestProcessor)this.graph, new Object[]{args});
                this.stack.push(result);
            } else {
                Layer0 L0 = Layer0.getInstance((ReadGraph)this.graph);
                Instances instances = (Instances)this.graph.adapt(L0.Function, Instances.class);
                Collection functions = instances.find(this.graph, this.model, "Name:" + functionName);
                if (functions != null && functions.size() == 1) {
                    Resource functionResource = (Resource)functions.iterator().next();
                    function = (Function)this.graph.adapt(functionResource, Function.class);
                    LinkedList<Object> args = new LinkedList<Object>();
                    int argc = this.countArguments(node.getArgList());
                    int i = 0;
                    while (i < argc) {
                        args.addFirst(this.stack.pop());
                        ++i;
                    }
                    args.addFirst(this.cellVariable);
                    Object result = function.apply((RequestProcessor)this.graph, args.toArray());
                    this.stack.push(result);
                } else {
                    this.stack.push(null);
                }
            }
        }
        catch (DatabaseException e) {
            this.stack.push(null);
        }
    }

    public static class ApplicationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ApplicationException(String message) {
            super(message);
        }
    }
}

