/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.AsyncListenerSupport;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.SyncListenerSupport;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.single.SingleSetSyncListenerDelegate;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.session.SessionEventListenerAdapter;
import org.simantics.db.event.SessionEventListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.SessionEventSupport;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.CellModifier;
import org.simantics.spreadsheet.CommandCellExecutor;
import org.simantics.spreadsheet.common.cell.SheetManipulator;
import org.simantics.spreadsheet.common.logging.Logger;
import org.simantics.spreadsheet.event.model.RemoveCellHandler;
import org.simantics.spreadsheet.graph.CellValue;
import org.simantics.spreadsheet.graph.Cells;
import org.simantics.spreadsheet.graph.FilteredVariableProperties;
import org.simantics.spreadsheet.graph.Ranges;
import org.simantics.spreadsheet.graph.Sources;
import org.simantics.spreadsheet.graph.adapter.SheetVariableSpaceManipulator;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class GraphUI
implements Adaptable,
ListenerSupport,
AsyncListenerSupport,
SyncListenerSupport {
    public static final boolean DEBUG = false;
    private final RequestProcessor processor;
    private CellEditor cellEditor;
    private Variable variable;
    private CellModifier client;
    private SessionEventListenerAdapter listener;
    private String currentSource;

    public GraphUI(RequestProcessor processor) {
        this.processor = processor;
    }

    public void addCell(ReadGraph graph, Pair<String, Variable> child, CellModifier client) throws DatabaseException {
        String childName = ((Variable)child.second).getName(graph);
        Boolean immutable = (Boolean)((Variable)child.second).getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
        if (immutable != null && immutable.booleanValue()) {
            Collection properties = ((Variable)child.second).getProperties(graph, "http://www.simantics.org/Spreadsheet-1.2/Attribute");
            this.addProperties(graph, properties, client, childName);
        } else {
            graph.asyncRequest((Read)new FilteredVariableProperties((Variable)child.second), this.propertyListener(client, childName));
        }
    }

    public void removeCell(ReadGraph graph, Pair<String, Variable> child, CellModifier client) throws DatabaseException {
        client.clear((String)child.first);
    }

    public void loadCells(ReadGraph graph, Variable container, boolean immutable, final CellModifier client) throws DatabaseException {
        if (immutable) {
            for (Pair cell : (Collection)graph.syncRequest((Read)new Cells(this.variable), (AsyncProcedure)TransientCacheAsyncListener.instance())) {
                this.addCell(graph, (Pair<String, Variable>)cell, client);
            }
        } else {
            graph.syncRequest((Read)new Cells(this.variable), (AsyncProcedure)new SingleSetSyncListenerDelegate<Pair<String, Variable>>((AsyncListenerSupport)this){

                public void add(ReadGraph graph, Pair<String, Variable> child) throws DatabaseException {
                    GraphUI.this.addCell(graph, child, client);
                }

                public void remove(ReadGraph graph, Pair<String, Variable> child) throws DatabaseException {
                    GraphUI.this.removeCell(graph, child, client);
                }
            });
        }
    }

    public Resource load(final Variable variable, final CellModifier client) throws DatabaseException {
        assert (variable != null);
        this.variable = variable;
        this.client = client;
        SessionEventSupport support = (SessionEventSupport)this.processor.getService(SessionEventSupport.class);
        if (this.listener != null) {
            support.removeListener((SessionEventListener)this.listener);
        }
        this.listener = new SessionEventListenerAdapter(){

            public void writeTransactionFinished() {
                client.flush();
            }
        };
        support.addListener((SessionEventListener)this.listener);
        this.cellEditor = (CellEditor)this.processor.sync((ReadInterface)new VariableRead<CellEditor>(variable){

            public CellEditor perform(ReadGraph graph) throws DatabaseException {
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                return (CellEditor)this.variable.getPropertyValue(graph, SHEET.cellEditor);
            }
        });
        ITask task = ThreadLogger.getInstance().begin("GraphUI.init");
        client.clearAll();
        Map sources = (Map)this.processor.syncRequest((Read)new Sources(variable));
        if (this.currentSource == null) {
            this.currentSource = "Sheet";
        }
        ArrayList sourceList = new ArrayList(sources.keySet());
        Collections.sort(sourceList, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
        if (!sourceList.contains(this.currentSource)) {
            sourceList.add(this.currentSource);
        }
        client.setProperty("Sources", "available", (Object)sourceList.toArray(new String[sourceList.size()]));
        client.setProperty("Sources", "current", (Object)this.currentSource);
        this.processor.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphUI.this.loadCells(graph, variable, false, client);
                graph.syncRequest((Read)new Ranges(variable), (AsyncProcedure)new SingleSetSyncListenerDelegate<Variable>((AsyncListenerSupport)GraphUI.this){

                    public void add(ReadGraph graph, Variable range) throws DatabaseException {
                        Boolean immutable = (Boolean)range.getPossiblePropertyValue(graph, "immutable", (Binding)Bindings.BOOLEAN);
                        GraphUI.this.loadCells(graph, range, immutable != null && immutable != false, client);
                    }

                    public void remove(ReadGraph graph, Variable range) throws DatabaseException {
                    }
                });
            }
        });
        task.finish();
        client.flush();
        return null;
    }

    private AsyncListener<Collection<Pair<String, Variable>>> propertyListener(final CellModifier client, final String childName) {
        return new SingleSetSyncListenerDelegate<Pair<String, Variable>>((AsyncListenerSupport)this){

            public void add(ReadGraph graph, final Pair<String, Variable> property) throws DatabaseException {
                graph.asyncRequest((Read)new CellValue((Variable)property.second), (SyncListener)new SyncListener<Object>(){

                    public void execute(ReadGraph graph, Object value) throws DatabaseException {
                        String propertyName = (String)property.first;
                        client.setProperty(childName, propertyName, value);
                    }

                    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
                        Logger.defaultLogError((Throwable)throwable);
                        String propertyName = (String)property.first;
                        if ("content".equals(propertyName)) {
                            String message;
                            if (throwable == null) {
                                throwable = new Exception();
                            }
                            if ((message = throwable.getMessage()) == null) {
                                message = throwable.toString();
                            }
                            client.setProperty(childName, propertyName, (Object)Variant.ofInstance((Object)message));
                        } else {
                            client.setProperty(childName, propertyName, null);
                        }
                    }

                    public boolean isDisposed() {
                        return GraphUI.this.isDisposed();
                    }
                });
            }
        };
    }

    private void addProperties(ReadGraph graph, Collection<Variable> properties, CellModifier client, String childName) throws DatabaseException {
        for (Variable property : properties) {
            String propertyName = property.getName(graph);
            Object value = property.getValue(graph);
            client.setProperty(childName, propertyName, value);
            String expression = (String)property.getPossiblePropertyValue(graph, "expression", (Binding)Bindings.STRING);
            if (expression == null) continue;
            client.setProperty(childName, String.valueOf(propertyName) + "#expression", (Object)expression);
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (Variable.class == clazz) {
            return (T)this.variable;
        }
        if (SheetManipulator.class == clazz) {
            return (T)new SheetManipulator(){

                public void post(final VariableSpaceManipulator.Modification modification) {
                    try {
                        GraphUI.this.processor.syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SheetVariableSpaceManipulator manipulator = new SheetVariableSpaceManipulator(GraphUI.this.variable);
                                manipulator.apply(graph, modification);
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                }
            };
        }
        if (CommandCellExecutor.class == clazz) {
            return (T)new CommandCellExecutor(){

                public void execute(int row, int column) {
                }
            };
        }
        if (RemoveCellHandler.class == clazz) {
            return (T)new RemoveCellHandler(){

                public void handle(final String location) {
                    GraphUI.this.processor.asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            Resource config;
                            Variable cellVariable = GraphUI.this.variable.getPossibleChild(graph, location);
                            if (cellVariable != null && (config = (Resource)cellVariable.getPossiblePropertyValue(graph, "Represents")) != null) {
                                graph.asyncRequest((Write)new WriteRequest(){

                                    public void perform(WriteGraph graph) throws DatabaseException {
                                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                        graph.deny(config, l0.PartOf);
                                    }
                                });
                            }
                        }
                    });
                }
            };
        }
        if (CellEditor.class == clazz) {
            return (T)new CellEditor(){

                public <T> void edit(CellEditor.Transaction transaction, String location, String property, T value, Binding binding) {
                    if ("Sources".equals(location)) {
                        if ("current".equals(property)) {
                            try {
                                Resource res = WorkbenchSelectionUtils.getPossibleResource(value);
                                if (res != null) {
                                    System.err.println("res=" + res);
                                    Variable newInput = (Variable)GraphUI.this.processor.syncRequest((Read)new ResourceRead<Variable>(res){

                                        public Variable perform(ReadGraph graph) throws DatabaseException {
                                            Variable base = ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)GraphUI.this.variable);
                                            Variable in = Variables.getVariable((ReadGraph)graph, (Resource)this.resource);
                                            GraphUI.this.currentSource = in.getURI(graph);
                                            return ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)base, (Variable)in);
                                        }
                                    });
                                    GraphUI.this.load(newInput, GraphUI.this.client);
                                    return;
                                }
                                if (value instanceof String) {
                                    Variable newInput = (Variable)GraphUI.this.processor.syncRequest((Read)new UnaryRead<String, Variable>((String)value){

                                        public Variable perform(ReadGraph graph) throws DatabaseException {
                                            Variable base = ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)GraphUI.this.variable);
                                            Map sources = (Map)graph.syncRequest((Read)new Sources(base));
                                            Variable found = (Variable)sources.get(this.parameter);
                                            if (found == null) {
                                                return null;
                                            }
                                            GraphUI.this.currentSource = (String)this.parameter;
                                            return ProxyVariables.makeProxyVariable((ReadGraph)graph, (Variable)base, (Variable)found);
                                        }
                                    });
                                    GraphUI.this.load(newInput, GraphUI.this.client);
                                }
                            }
                            catch (DatabaseException e) {
                                Logger.defaultLogError((Throwable)e);
                            }
                        }
                        return;
                    }
                    GraphUI.this.cellEditor.edit(transaction, location, property, value, binding);
                }

                public void edit(CellEditor.Transaction transaction, String location, Variant variant) {
                    GraphUI.this.cellEditor.edit(transaction, location, variant);
                }

                public void copy(CellEditor.Transaction transaction, String location, MutableVariant variant) {
                    GraphUI.this.cellEditor.edit(transaction, location, (Variant)variant);
                }

                public CellEditor.Transaction startTransaction() {
                    return GraphUI.this.cellEditor.startTransaction();
                }
            };
        }
        return null;
    }

    public void exception(Throwable t) {
        t.printStackTrace();
    }

    public boolean isDisposed() {
        return false;
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        Logger.defaultLogError((String)"Failed to read properties.", (Throwable)t);
    }

    public void exception(ReadGraph graph, Throwable t) {
        Logger.defaultLogError((String)"Failed to read properties.", (Throwable)t);
    }
}

