/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadInterface;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.Pair;

public class Cells
extends UnaryRead<Variable, Collection<Pair<String, Variable>>> {
    private static Set<String> CLASSIFICATIONS = new HashSet<String>();

    static {
        CLASSIFICATIONS.add("http://www.simantics.org/Spreadsheet-1.2/Attribute");
    }

    public Cells(Variable variable) {
        super((Object)variable);
    }

    public Collection<Pair<String, Variable>> perform(ReadGraph graph) throws DatabaseException {
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        ArrayList<Pair<String, Variable>> result = new ArrayList<Pair<String, Variable>>();
        for (Variable child : ((Variable)this.parameter).getChildren(graph)) {
            Resource type = child.getPossibleType(graph);
            if (type == null) continue;
            if (graph.isInheritedFrom(type, SHEET.Range)) {
                try {
                    Collection rangeCells = (Collection)graph.sync((ReadInterface)new Cells(child));
                    result.addAll(rangeCells);
                }
                catch (DatabaseException e) {
                    String location = (String)child.getPossiblePropertyValue(graph, SHEET.Range_location, (Binding)Bindings.STRING);
                    if (location == null) {
                        location = "A1";
                    }
                    result.add(Cells.error(graph, child, location, e));
                    Logger.defaultLogError((Throwable)e);
                }
                continue;
            }
            if (!graph.isInheritedFrom(type, SHEET.Cell)) continue;
            try {
                String name = child.getName(graph);
                result.add((Pair<String, Variable>)Pair.make((Object)name, (Object)child));
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
        return result;
    }

    private static Pair<String, Variable> error(ReadGraph graph, Variable child, String location, DatabaseException e) throws DatabaseException {
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        ArrayList<ConstantPropertyVariableBuilder> builders = new ArrayList<ConstantPropertyVariableBuilder>();
        builders.add(new ConstantPropertyVariableBuilder("content", (Object)Variant.ofInstance((Object)e.getExplanation(graph)), (Binding)Bindings.VARIANT, Collections.emptyList(), CLASSIFICATIONS));
        builders.add(new ConstantPropertyVariableBuilder("Type", (Object)SHEET.Cell, null, Collections.emptyList(), Collections.emptySet()));
        ConstantChildVariable var = new ConstantChildVariable(child, location, builders);
        return new Pair((Object)location, (Object)var);
    }
}

