/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.loader;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.AssumptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.request.VariableName;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.loader.SceneGraphContext;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.FunctionImpl2;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class ScenegraphLoaderUtils {
    static Map<Pair<Variable, String>, Collection<Listener<Object>>> externalMap = new HashMap<Pair<Variable, String>, Collection<Listener<Object>>>();
    static Map<Pair<Variable, String>, Object> externalValueMap = new HashMap<Pair<Variable, String>, Object>();

    public static Collection<Variable> computeChildren(ReadGraph graph, Variable configuration) throws DatabaseException {
        ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
        Resource represents = configuration.getRepresents(graph);
        Collection children = (Collection)graph.getPossibleRelatedValue2(represents, SG.Node_children, (Object)configuration);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Resource item : children) {
            VariableBuilder variableBuilder = (VariableBuilder)graph.adapt(item, VariableBuilder.class);
            Variable child = variableBuilder.buildChild(graph, configuration, null, item);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    public static Collection<Variable> getChildren(RequestProcessor processor, Variable configuration) throws DatabaseException {
        return (Collection)processor.sync((ReadInterface)new UnaryRead<Variable, Collection<Variable>>(configuration){

            public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
                return ((Variable)this.parameter).browseChildren(graph);
            }
        });
    }

    public static Collection<Variable> getChildren(Resource configuration) throws DatabaseException {
        return (Collection)Simantics.getSession().sync((ReadInterface)new ResourceRead<Collection<Variable>>(configuration){

            public Collection<Variable> perform(ReadGraph graph) throws DatabaseException {
                return ScenegraphLoaderUtils.computeChildren(graph, Variables.getVariable((ReadGraph)graph, (Resource)this.resource));
            }
        });
    }

    public static Collection<NamedResource> getProperties(RequestProcessor processor, Resource configuration) throws DatabaseException {
        return (Collection)processor.sync((ReadInterface)new ResourceRead<Collection<NamedResource>>(configuration){

            public Collection<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                ArrayList<NamedResource> result = new ArrayList<NamedResource>();
                for (Resource predicate : graph.getPredicates(this.resource)) {
                    if (!graph.isSubrelationOf(predicate, SG.Node_HasProperty)) continue;
                    String name = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
                    result.add(new NamedResource(name, predicate));
                }
                return result;
            }
        });
    }

    public static <T> void listen(RequestProcessor processor, final ScenegraphLoaderProcess process, final Variable context, String property, final Function1<T, Boolean> function) throws DatabaseException {
        try {
            processor.syncRequest((Read)new BinaryRead<Variable, String, T>(context, property){

                public T perform(ReadGraph graph) throws DatabaseException {
                    SceneGraphContext vc = ScenegraphLoaderUtils.getContext(graph, context);
                    if (vc == null) {
                        throw new DisposedRuntimeException("No scene graph context");
                    }
                    Resource runtime = vc.getRuntime();
                    if (runtime == null || !graph.hasStatement(runtime)) {
                        throw new DisposedRuntimeException("Scene graph runtime disposed");
                    }
                    return ((Variable)this.parameter).getPropertyValue(graph, (String)this.parameter2);
                }
            }, new Listener<T>(){
                private boolean disposed = false;

                public void exception(Throwable t) {
                    if (t instanceof DisposedRuntimeException) {
                        this.disposed = true;
                    }
                }

                public void execute(T result) {
                    if (!this.disposed) {
                        this.disposed = (Boolean)function.apply(result);
                    }
                }

                public boolean isDisposed() {
                    return process.isDisposed() | this.disposed;
                }

                public String toString() {
                    return "Scenegraph Property Listener for " + process;
                }
            });
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    public static Resource getRuntime(ReadGraph graph, Variable context) throws DatabaseException {
        SceneGraphContext vc = ScenegraphLoaderUtils.getContext(graph, context);
        if (vc != null) {
            return vc.getRuntime();
        }
        Variable parent = context.getParent(graph);
        if (parent == null) {
            throw new DatabaseException("Runtime resource was not found from context Variable.");
        }
        return ScenegraphLoaderUtils.getRuntime(graph, parent);
    }

    public static SceneGraphContext getContext(ReadGraph graph, Variable context) throws DatabaseException {
        SceneGraphContext vc = (SceneGraphContext)context.adaptPossible(graph, SceneGraphContext.class);
        if (vc != null) {
            return vc;
        }
        Variable parent = context.getParent(graph);
        if (parent != null) {
            return ScenegraphLoaderUtils.getContext(graph, parent);
        }
        return null;
    }

    public static Variable getRuntimeVariable(ReadGraph graph, Variable context) throws DatabaseException {
        SceneGraphContext vc = ScenegraphLoaderUtils.getContext(graph, context);
        if (vc == null) {
            return null;
        }
        return vc.getRuntimeVariable();
    }

    public static Variable getBaseVariable(ReadGraph graph, Variable context) throws DatabaseException {
        Variable parent = context.getParent(graph);
        if (parent == null) {
            return null;
        }
        if (context instanceof ScenegraphVariable && !(parent instanceof ScenegraphVariable)) {
            return context;
        }
        return ScenegraphLoaderUtils.getBaseVariable(graph, parent);
    }

    public static INode create(RequestProcessor processor, ScenegraphLoaderProcess process, ParentNode<?> parent, Resource configuration, Variable context, Class<?> clazz) throws DatabaseException {
        String name = (String)processor.sync((ReadInterface)new VariableName(context));
        String uri = (String)processor.sync((ReadInterface)new VariableURI(context));
        LoaderNode node = (LoaderNode)parent.addNode(name, clazz);
        final Pair reference = (Pair)processor.sync((ReadInterface)new ScenegraphReference(context));
        node.setPropertyCallback((Function2)new FunctionImpl2<String, Object, Boolean>(){

            public Boolean apply(String property, Object value) {
                Pair key = Pair.make((Object)((Variable)reference.first), (Object)(String.valueOf((String)reference.second) + "#" + property));
                externalValueMap.put((Pair<Variable, String>)key, value);
                Collection<Listener<Object>> listeners = externalMap.get(key);
                if (listeners != null) {
                    for (Listener<Object> listener : listeners) {
                        listener.execute(value);
                    }
                }
                return true;
            }
        });
        for (NamedResource property : ScenegraphLoaderUtils.getProperties(processor, configuration)) {
            try {
                Function1 func = node.getPropertyFunction(property.getName());
                if (func == null) continue;
                ScenegraphLoaderUtils.listen(processor, process, context, property.getName(), func);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    public static Variable getVariableSelection(ReadGraph graph, Variable context) throws DatabaseException {
        Variable runtimeVariable = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
        if (runtimeVariable == null) {
            throw new VariableException("no runtime variable for context " + context.getURI(graph));
        }
        return (Variable)runtimeVariable.getPropertyValue(graph, "variable");
    }

    public static Variable getPossibleVariableSelection(ReadGraph graph, Variable context) throws DatabaseException {
        Variable runtimeVariable = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
        return runtimeVariable == null ? null : (Variable)runtimeVariable.getPossiblePropertyValue(graph, "variable");
    }

    public static Resource getResourceSelection(ReadGraph graph, Variable context) throws DatabaseException {
        Variable runtimeVariable = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
        if (runtimeVariable == null) {
            throw new VariableException("no runtime variable for context " + context.getURI(graph));
        }
        Resource sel = (Resource)runtimeVariable.getPropertyValue(graph, "resource");
        return sel;
    }

    public static Resource getPossibleResourceSelection(ReadGraph graph, Variable context) throws DatabaseException {
        Variable runtimeVariable = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
        return runtimeVariable == null ? null : (Resource)runtimeVariable.getPossiblePropertyValue(graph, "resource");
    }

    public static INode getNode(ReadGraph graph, Variable location) throws DatabaseException {
        Variable runtime = ScenegraphLoaderUtils.getRuntimeVariable(graph, location);
        INode root = (INode)runtime.adapt(graph, INode.class);
        Variable base = ScenegraphLoaderUtils.getBaseVariable(graph, location);
        String rvi = Variables.getRVI((ReadGraph)graph, (Variable)base, (Variable)location);
        return NodeUtil.browsePossible((INode)root, (String)rvi);
    }

    public static <T> T getProperty(IThreadWorkQueue thread, INode _root, String reference) {
        INode root = (INode)((ParentNode)_root).getNodes().iterator().next();
        final Pair ref = NodeUtil.browsePossibleReference((INode)root, (String)reference);
        final DataContainer result = new DataContainer();
        ThreadUtils.syncExec((IThreadWorkQueue)thread, (Runnable)new Runnable(){

            @Override
            public void run() {
                Object value = ScenegraphLoaderUtils.getNodeProperty((LoaderNode)ref.first, (String)ref.second);
                result.set(value);
            }
        });
        return (T)result.get();
    }

    public static <T> ScenegraphPropertyReference<T> getRelativePropertyReference(IThreadWorkQueue thread, ReadGraph graph, Variable context, String path) throws DatabaseException {
        Variable runtime = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
        INode root = (INode)runtime.adapt(graph, INode.class);
        Variable base = ScenegraphLoaderUtils.getBaseVariable(graph, context);
        INode baseNode = NodeUtil.findChildById((ParentNode)((ParentNode)root), (String)base.getName(graph));
        String contextRVI = Variables.getRVI((ReadGraph)graph, (Variable)base, (Variable)context);
        String rvi = Variables.getRVI((String)contextRVI, (String)path);
        return new ScenegraphPropertyReference(thread, baseNode, rvi, base);
    }

    public static <T> ScenegraphPropertyReference<T> getPropertyReference(IThreadWorkQueue thread, ReadGraph graph, Variable context, String path) throws DatabaseException {
        Variable runtime = ScenegraphLoaderUtils.getRuntimeVariable(graph, context);
        INode root = (INode)runtime.adapt(graph, INode.class);
        Variable base = ScenegraphLoaderUtils.getBaseVariable(graph, context);
        return new ScenegraphPropertyReference(thread, root, path, base);
    }

    public static Method getSynchronizeMethod(INode node, String propertyName) {
        try {
            String methodName = "synchronize" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            Method[] methodArray = node.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().equals(methodName)) {
                    return m;
                }
                ++n2;
            }
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getReadMethod(INode node, String propertyName) {
        try {
            String methodName = "read" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            return node.getClass().getMethod(methodName, new Class[0]);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field getPropertyField(INode node, String propertyName) {
        try {
            return node.getClass().getField(propertyName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            System.err.println("node:" + node);
            e.printStackTrace();
        }
        return null;
    }

    public static Class<?> getPropertyType(Field field) {
        return field.getType();
    }

    public static Class<?> getArgumentType(Method method) {
        return (Class)method.getGenericParameterTypes()[0];
    }

    public static Class<?> getReturnType(Method method) {
        return method.getReturnType();
    }

    public static Binding getPropertyBinding(Class<?> clazz) {
        try {
            return Bindings.getBindingUnchecked(clazz);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Binding getGenericPropertyBinding(Binding binding) {
        try {
            return Bindings.getBinding((Datatype)binding.type());
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Function1<Object, Boolean> getPropertyFunction(LoaderNode node, String propertyName) {
        return node.getPropertyFunction(propertyName);
    }

    public static <T> T getNodeProperty(LoaderNode node, String propertyName) {
        return (T)node.getProperty(propertyName);
    }

    public static String getPath(ReadGraph graph, Variable context) throws DatabaseException {
        Variable base = ScenegraphLoaderUtils.getBaseVariable(graph, context);
        return Variables.getRVI((ReadGraph)graph, (Variable)base, (Variable)context);
    }

    static class DisposedRuntimeException
    extends AssumptionException {
        private static final long serialVersionUID = 5213099691410928157L;

        public DisposedRuntimeException(String message) {
            super(message);
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class ScenegraphPropertyReference<T> {
        Variable baseVariable;
        IThreadWorkQueue thread;
        INode root;
        String reference;
        T value = null;

        public ScenegraphPropertyReference(IThreadWorkQueue thread, INode root, String reference, Variable baseVariable) {
            assert (root != null);
            this.thread = thread;
            this.root = root;
            this.reference = reference;
            this.baseVariable = baseVariable;
        }

        public T getExternalValue(RequestProcessor processor) throws DatabaseException {
            return (T)processor.sync(new ExternalRead(this.baseVariable, this.reference));
        }

        public T getValue() {
            final Pair ref = NodeUtil.browsePossibleReference((INode)this.root, (String)this.reference);
            final DataContainer result = new DataContainer();
            ThreadUtils.syncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

                @Override
                public void run() {
                    Object value = ScenegraphLoaderUtils.getNodeProperty((LoaderNode)ref.first, (String)ref.second);
                    result.set(value);
                }
            });
            return (T)result.get();
        }

        public void setValue(final T value) {
            final Pair ref = NodeUtil.browsePossibleReference((INode)this.root, (String)this.reference);
            if (ref != null) {
                ThreadUtils.asyncExec((IThreadWorkQueue)this.thread, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Function1<Object, Boolean> function = ScenegraphLoaderUtils.getPropertyFunction((LoaderNode)ref.first, (String)ref.second);
                        if (function != null) {
                            function.apply(value);
                        } else {
                            new Exception("no function for ref " + ref).printStackTrace();
                        }
                    }
                });
            }
        }

        static class ExternalRead<T>
        extends ParametrizedPrimitiveRead<Pair<Variable, String>, T> {
            public ExternalRead(Variable base, String path) {
                super((Object)Pair.make((Object)base, (Object)path));
            }

            public void register(ReadGraph graph, final Listener<T> procedure) {
                Object value = externalValueMap.get(this.parameter);
                procedure.execute(value);
                Collection<Listener<Object>> listeners = externalMap.get(this.parameter);
                if (listeners == null) {
                    listeners = new ArrayList<Listener<Object>>();
                    externalMap.put((Pair<Variable, String>)((Pair)this.parameter), listeners);
                }
                listeners.add((Listener<Object>)new ListenerAdapter<Object>(){

                    public void execute(Object result) {
                        procedure.execute(result);
                    }
                });
            }

            public void unregistered() {
                externalMap.remove(this.parameter);
            }
        }
    }

    static class ScenegraphReference
    extends UnaryRead<Variable, Pair<Variable, String>> {
        public ScenegraphReference(Variable var) {
            super((Object)var);
            assert (var != null);
        }

        public Pair<Variable, String> perform(ReadGraph graph) throws DatabaseException {
            Variable base = ScenegraphLoaderUtils.getBaseVariable(graph, (Variable)this.parameter);
            return Pair.make((Object)base, (Object)Variables.getRVI((ReadGraph)graph, (Variable)base, (Variable)((Variable)this.parameter)));
        }
    }
}

