package org.simantics.db.common.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

import org.simantics.databoard.util.URIStringUtils;

public class URITest {

    private static final int COUNT = 1000000;
    private static final String TEST_STR = "http://www.simantics.org/Layer0-1.0/HasInverse/Inverse";
    //private static final String TEST_STR = "http--www.simantics.org-Layer0-1.0-HasInverse-Inverse";

    public static void main(String[] args) {
        try {
            String s1 = URLEncoder.encode(TEST_STR, "UTF-8");
            String s2 = URIStringUtils.escape(TEST_STR);
            System.out.println("URLEncoder.encode(" + TEST_STR + "): " + s1);
            System.out.println("URIStringUtils.escapeAll(" + TEST_STR + "): " + s2);
            String ds1 = URLDecoder.decode(s1, "UTF-8");
            String ds2 = URIStringUtils.unescape(s2);
            System.out.println("ds1: " + ds1);
            System.out.println("ds2: " + ds2);
            String ds1x2 = URIStringUtils.unescape(s2);
            String ds2x1 = URLDecoder.decode(s1, "UTF-8");
            System.out.println("ds1x2: " + ds1x2);
            System.out.println("ds2x1: " + ds2x1);

            long start = System.nanoTime();
            for (int i = 0; i < COUNT; ++i) {
                String s = URLEncoder.encode(TEST_STR, "UTF-8");
            }
            long end = System.nanoTime();
            System.out.println("URLEncoder: " + ((end-start)*1e-9));

            long start2 = System.nanoTime();
            for (int i = 0; i < COUNT; ++i) {
                String s = URIStringUtils.escape(TEST_STR);
            }
            long end2 = System.nanoTime();
            System.out.println("URIStringUtils.escape: " + ((end2-start2)*1e-9));

            long start3 = System.nanoTime();
            for (int i = 0; i < COUNT; ++i) {
                String s = URLDecoder.decode(ds1, "UTF-8");
            }
            long end3 = System.nanoTime();
            System.out.println("URLDecoder: " + ((end3-start3)*1e-9));

            long start4 = System.nanoTime();
            for (int i = 0; i < COUNT; ++i) {
                String s = URIStringUtils.unescape(ds2);
            }
            long end4 = System.nanoTime();
            System.out.println("URIStringUtils.decode: " + ((end4-start4)*1e-9));

        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
    }

}
