package org.simantics.db.common.utils;

import java.lang.reflect.InvocationTargetException;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.AdaptValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.function.Function;

public class Functions {
	
	private static DatabaseException findPossibleRootException(Throwable t) {
		if(t == null) return null;
		if(t instanceof DatabaseException) return (DatabaseException)t;
		if(t instanceof RuntimeException || t instanceof InvocationTargetException) {
			return findPossibleRootException(t.getCause());
		}
		return null;
	}
 	
	public static <T> T exec(RequestProcessor rp, Resource function, Object ... parameters) throws DatabaseException {
        Object op = rp.syncRequest(new AdaptValue(function));
        try {
        	return (T) ((Function)op).applyArray(parameters);
        } catch (RuntimeException e) {
        	DatabaseException dte = findPossibleRootException(e);
        	if(dte != null) throw dte;
        	else throw new DatabaseException(e);
        }
	}
	
}
