/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.uri;

import java.util.Collection;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.Development;

public class UnescapedChildMapOfResource extends ResourceRead<Map<String, Resource>> {

	public UnescapedChildMapOfResource(Resource resource) {
	    super(resource);
	}
	
	@Override
	public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
	    Layer0 L0 = Layer0.getInstance(graph);
	    Collection<Resource> objects = graph.getObjects(resource, L0.ConsistsOf);
	    CollectionSupport cs = graph.getService(CollectionSupport.class);
	    Map<String,Resource> result = cs.createObjectResourceMap(String.class, objects.size());
	    for(Resource r : objects) {
	        String name = graph.getPossibleRelatedValue(r, L0.HasName, Bindings.STRING);
	        if(name != null) {
	            Resource old = result.put(name, r);
	            if (old != null)
	                System.err.println(this + ": The database contains siblings with the same name " + name + " (resource=$" + resource.getResourceId() + ", child=$" + r.getResourceId() + ", previous child=$" + old.getResourceId() + ").");
	        } else {
	        	if(Development.DEVELOPMENT)
		            System.err.println(this + ": The database contains a child with no unique name (resource=$" + resource.getResourceId() + ", child=$" + r.getResourceId() + ").");
	        }
	    }
	    return result;
	}	
	
}
