package org.simantics.db.common.service;

import org.simantics.db.Session;
import org.simantics.db.common.session.SessionEventListenerAdapter;
import org.simantics.db.service.ServiceActivityMonitor;
import org.simantics.db.service.SessionEventSupport;

public class ServiceActivityUpdaterForWriteTransactions
        extends SessionEventListenerAdapter {

    private final ServiceActivityMonitor serviceActivityMonitor;
    
    public ServiceActivityUpdaterForWriteTransactions(
            ServiceActivityMonitor serviceActivityMonitor) {
        this.serviceActivityMonitor = serviceActivityMonitor;
    }

    @Override
    public void writeTransactionStarted() {
        serviceActivityMonitor.registerActivity(this);
    }

    @Override
    public void writeTransactionFinished() {
        serviceActivityMonitor.unregisterActivity(this);
    }
    
    public static void register(Session session) {
        ServiceActivityUpdaterForWriteTransactions updater =
                new ServiceActivityUpdaterForWriteTransactions(
                        session.getService(ServiceActivityMonitor.class));
        session.getService(SessionEventSupport.class).addListener(updater);
    }

}
