/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class SuperTypeString extends BinaryRead<Resource, String, String> {

    public SuperTypeString(Resource type) {
        super(type, " ");
    }

    public SuperTypeString(Resource type, String separator) {
        super(type, separator);
        if (separator == null)
            throw new NullPointerException("null separator");
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
    	
    	Layer0 L0 = Layer0.getInstance(graph);
    	Set<Resource> supers = graph.getSupertypes(parameter);
        final StringBuilder b = new StringBuilder();
        String name = graph.getPossibleRelatedValue(parameter, L0.HasName, Bindings.STRING);
        if(name != null) {
        	b.append(name);
            for (Resource r : supers) {
            	name = graph.getPossibleRelatedValue(r, L0.HasName, Bindings.STRING);
            	if(name != null) {
	                b.append(parameter2);
	                b.append(name);
            	} else {
                	Logger.defaultLogError(new DatabaseException("No name for type " + r));
            	}
            }
        } else {
        	Logger.defaultLogError(new DatabaseException("No name for type " + parameter));
        }
        
        return b.toString();

    }

}