/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;

import java.util.Collection;
import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class PropertyMapOfResource extends ResourceRead<Map<String, Resource>> {

	public PropertyMapOfResource(Resource resource) {
	    super(resource);
	}

	@Override
	public Map<String,Resource> perform(ReadGraph graph) throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		Collection<Resource> predicates = graph.getPredicates(resource); 
        THashMap<String, Resource> result = new THashMap<String, Resource>(predicates.size());
		for(Resource predicate : predicates) {
			if(graph.isSubrelationOf(predicate, L0.HasProperty)) {
		        String name = graph.getPossibleRelatedValue(predicate, L0.HasName, Bindings.STRING);
		        if(name != null) {
					String escapedName = URIStringUtils.escape(name); 
		            if (result.put(escapedName, predicate) != null)
		                System.err.println(this + ": The database contains siblings with the same name " + name + " (resource=$" + resource.getResourceId() +").");
		        }
			}				
		}
		return result;
		
	}
	
}
