package org.simantics.db.common.request;

import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class PossibleOwner extends ResourceRead<Resource> {

    public PossibleOwner(Resource resource) {
        super(resource);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        Resource directOwner = graph.getPossibleObject(resource, L0.IsOwnedBy);
        if(directOwner != null) return directOwner;
        return CommonDBUtils.getNearestOwner(graph, Collections.singleton(resource));
    }
    
}