/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ProcedureBarrier;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;

final public class ObjectsWithTypeAsync extends ResourceAsyncRead3<Collection<Resource>> {

    public ObjectsWithTypeAsync(Resource subject, Resource subrelationOf, Resource instanceOf) {
        super(subject, subrelationOf, instanceOf);
    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<Collection<Resource>> procedure) {

    	final Collection<Resource> result = new ConcurrentLinkedQueue<Resource>();
    	final ProcedureBarrier<Collection<Resource>> ready = new ProcedureBarrier<Collection<Resource>>(1);
    	
    	graph.forEachObject(resource, resource2, new AsyncMultiProcedure<Resource>() {

			@Override
			public void execute(AsyncReadGraph graph, final Resource object) {
				
				ready.incrementAndGet();
				
				graph.forTypes(object, new AsyncProcedure<Set<Resource>>() {
					
					@Override
					public void execute(AsyncReadGraph graph, Set<Resource> types) {

						if(types.contains(resource3)) {
							result.add(object);
						}
						
						ready.dec(graph, procedure, result);
						
					}
					
					@Override
					public void exception(AsyncReadGraph graph, Throwable throwable) {
						
						throwable.printStackTrace();
			    		Logger.defaultLogError(throwable);
						
						ready.except(throwable);
						ready.dec(graph, procedure, result);
						
					}
					
				});
				
			}

			@Override
			public void finished(AsyncReadGraph graph) {
				
				ready.dec(graph, procedure, result);
				
			}

			@Override
			public void exception(AsyncReadGraph graph, Throwable throwable) {
				
				throwable.printStackTrace();
	    		Logger.defaultLogError(throwable);
				
				ready.except(throwable);
				ready.dec(graph, procedure, result);
				
			}
    		
    	});
    	
    }
    
//    @Override
//    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
//        
//    	Set<Resource> result = new HashSet<Resource>();
//    	for(Resource object : graph.getObjects(resource, resource2)) {
//    		if(graph.isInstanceOf(object, resource3)) result.add(object);
//    	}
//    	return result;
//        
//    }

}
