/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import gnu.trove.map.hash.THashMap;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.Development;

public class DependentInstances3 extends ResourceRead<ResourceSetGraph> {

    private static final boolean DEBUG = false;
	
	private static ThreadLocal<THashMap<DependentInstances3, ResourceSetGraph>> workArea = new ThreadLocal<THashMap<DependentInstances3, ResourceSetGraph>>();

	public DependentInstances3(Resource resource) {
		super(resource);
	}

	private static ResourceSetGraph test(DependentInstances3 instance) {
		THashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
		if(set == null) return null;
		else return set.get(instance);
	}
	
	private void register(ResourceSetGraph result) {
		THashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
		if(set == null) {
			set = new THashMap<DependentInstances3, ResourceSetGraph>();
			workArea.set(set);
		}
		set.put(this, result);
	}

	private void unregister() {
		THashMap<DependentInstances3, ResourceSetGraph> set = workArea.get();
		if(set != null) set.remove(this);
	}
	
	@Override
	public ResourceSetGraph perform(ReadGraph graph) throws DatabaseException {
		
		if(resource.equals(graph.getRootLibrary())) return new ResourceSetGraph(graph, resource);
        
		if(Development.DEVELOPMENT)
			if(graph.isImmutable(resource))
				System.err.println("Immutable resource in DependentInstances3: " + NameUtils.getSafeName(graph, resource, true));
		
        // This is a loop
        ResourceSetGraph result = test(this);
        if(result != null) return result;

        result = new ResourceSetGraph(graph, resource);
        
        register(result);
        
        CollectionSupport cs = graph.getService(CollectionSupport.class);
        Set<Resource> objects = cs.createSet();
		
//        HashSet<Resource> objects = new HashSet<Resource>(); 
        
		Layer0 L0 = Layer0.getInstance(graph);
		for(Statement dep : graph.getStatements(resource, L0.IsDependencyOf)) {
			if(graph.isSubrelationOf(dep.getPredicate(), L0.HasPrevious)) continue;
			Resource object = dep.getObject();
			if(graph.isImmutable(object)) continue;
			objects.add(object);
		}
		
		for(Resource object : objects ) {
            if(DEBUG)
                System.err.println(NameUtils.getSafeName(graph, object, true) + " depends on " + NameUtils.getSafeName(graph, resource, true));
		    DependentInstances3 query = new DependentInstances3(object);
		    ResourceSetGraph instances = test(query);
		    if(instances == null) instances = graph.syncRequest(query);
			result.references.add(instances);
		}
		
		unregister();
		return result;
		
	}

}
