/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;

public abstract class BinaryParametrizedRead<P, C, C2, R> implements ParametrizedRead<P, R> {

    final protected C constant;
    final protected C2 constant2;
    
    public BinaryParametrizedRead(C constant, C2 constant2) {
    	this.constant = constant;
    	this.constant2 = constant2;
    }
	
	abstract public R perform(ReadGraph graph, P parameter) throws DatabaseException;
	
	@Override
	public Read<R> get(P parameter) {
		return new TernaryRead<P, C, C2, R>(parameter, constant, constant2) {

			@Override
			public R perform(ReadGraph graph) throws DatabaseException {
				return BinaryParametrizedRead.this.perform(graph, parameter);
			}
			
		};
	}
    
}
