/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;


abstract public class BinaryAsyncRead<P1, P2, R> extends UnaryAsyncRead<P1, R> {

    final protected P2 parameter2;

    @Override
    public int hashCode() {
        final int h1 = parameter != null ? parameter.hashCode() : 0;
        final int h2 = parameter2 != null ? parameter2.hashCode() : 0;
        return h1 + 31 * h2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        BinaryAsyncRead<?, ?, ?> r = (BinaryAsyncRead<?, ?, ?>) object;
        if(parameter != null) {
            if(!parameter.equals(r.parameter)) return false;
        } else if(r.parameter != null) return false;
        if(parameter2 != null) {
            if(!parameter2.equals(r.parameter2)) return false;
        } else if(r.parameter2 != null) return false;
        return true;
    }

    public BinaryAsyncRead(P1 parameter1, P2 parameter2) {
        super(parameter1);
        this.parameter2 = parameter2;
    }

}
