/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.primitiverequest;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.service.DirectQuerySupport;

final public class RelationInfoRequest extends ResourceAsyncRead<RelationInfo> {

    public RelationInfoRequest(Resource resource) {
        super(resource);
    }

	@Override
	public void perform(AsyncReadGraph graph, AsyncProcedure<RelationInfo> procedure) {
		DirectQuerySupport dqs = graph.getService(DirectQuerySupport.class);
		dqs.forRelationInfo(graph, resource, procedure);
	}
	
}
	