package org.simantics.db.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public class CommandMetadata implements Metadata {

    public static final boolean DEBUG = false;
    public static final String RESET_COMMAND = "// RESET";
    
    private static final Binding BINDING = 
            Bindings.getBindingUnchecked(CommandMetadata.class);
    private static final Serializer SERIALIZER = 
            Bindings.getSerializerUnchecked(BINDING);
    
    public List<Command> commands;
    
    public static class Command {
        public long modelId;
        public String command;
        
        public Command() {         
        }
        
        public Command(long modelId, String command) {
            super();
            this.modelId = modelId;
            this.command = command;
        }
    }
    
    public CommandMetadata() {
    }

    @Override
    public byte[] serialise(Session session) {
        try {
            return SERIALIZER.serialize(this);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
    
    public static CommandMetadata deserialise(Session session, byte[] input) {
        if(input == null) {
            CommandMetadata metadata = new CommandMetadata();
            metadata.commands = new ArrayList<Command>();
            return metadata;
        }
        try {
            return (CommandMetadata)SERIALIZER.deserialize(input);
        } catch (SerializationException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CommandMetadata add(Command command) {
        commands.add(command);
        return this;
    }
    
    public List<Command> getCommands() {
        return commands;
    }

    public static void add(WriteGraph graph, long modelId, String command) throws DatabaseException {
        if(DEBUG) {
            System.out.println("-------------------------------------------------------------");
            System.out.println(command);
        }
        graph.addMetadata(graph.getMetadata(CommandMetadata.class).add(
                new Command(modelId, command)));
    }
    
    public static void addReset(WriteGraph graph, long modelId) throws DatabaseException {
        graph.addMetadata(graph.getMetadata(CommandMetadata.class).add(
                new Command(modelId, RESET_COMMAND)));
    }
}
