/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.request;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class GetLabel extends ResourceRead<String> {

    public GetLabel(Resource r) {
        super(r);
    }

    @Override
    public String perform(ReadGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(graph);
        String label = graph.getPossibleRelatedValue(resource, l0.HasLabel, Bindings.STRING);
        if (label == null)
            label = graph.getPossibleRelatedValue(resource, l0.HasName, Bindings.STRING);
        if (label == null) {
            String rep = NameUtils.getSafeName(graph, resource);
            throw new ValidationException("Resource '" + rep + "' does not have a Label or a Name property.");
        }
        return label;
    }

}
