/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contributor.viewpoint;

import java.util.Collection;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;
import org.simantics.browsing.ui.graph.impl.contribution.CallbackViewpointContributionImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Callback;

abstract public class ContextInputCallbackViewpointContributorImpl implements Contributor<ViewpointContributionFactory> {

    abstract public void getContribution(ReadGraph graph, NodeContext context, Callback<Collection<?>> callback) throws DatabaseException;

    abstract public String getViewpointId();

    final private Class<?> clazz;

    @Override
    public Tester getNodeContextTester() {
        return null;
    }

    public ContextInputCallbackViewpointContributorImpl() {
        clazz = Object.class;
    }

    public ContextInputCallbackViewpointContributorImpl(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public ViewpointContributionFactory getFactory() {

        return new ViewpointContributionFactory() {

            @Override
            public String getViewpointId() {
                return ContextInputCallbackViewpointContributorImpl.this.getViewpointId();
            }

            @Override
            public ViewpointContribution create(final PrimitiveQueryUpdater updater, NodeContext context, final ViewpointContributionKey key) {

                return new CallbackViewpointContributionImpl(updater, context, key) {

                    @Override
                    public void children(ReadGraph graph, NodeContext context, Callback<Collection<?>> callback) throws DatabaseException {

                        ContextInputCallbackViewpointContributorImpl.this.getContribution(graph, context, callback);

                    }

                    @Override
                    public Tester getNodeContextTester() {
                        return ContextInputCallbackViewpointContributorImpl.this.getNodeContextTester();
                    }

                    @Override
                    public Class<?> getInputClass() {
                        return ContextInputCallbackViewpointContributorImpl.this.getInputClass();
                    }

                };

            }

        };

    }

    @Override
    public Class<?> getInputClass() {
        return clazz;
    }

}
