/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.common.viewpoints.LazyContainerViewpoint;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Callback;

public class TypeIndexViewpointFactory implements ViewpointFactory {

    @Override
    public Viewpoint create(final PrimitiveQueryUpdater provider, final NodeContext context, final ViewpointKey key) {
        assert(provider != null);
        assert(context != null);
        
        final LazyContainerViewpoint result = new LazyContainerViewpoint();
        
        DataSource<ReadGraph> source = provider.getDataSource(ReadGraph.class);
        if (source == null)
            return result;
        
        final Resource inputResource = (Resource) context.getConstant(BuiltinKeys.INPUT);
        assert(inputResource != null);
        
        source.schedule(new Callback<ReadGraph>() {

            @Override
            public void run(ReadGraph source) {

            	try {
            	
	                HashMap<Resource, Collection<Resource>> index = new HashMap<Resource, Collection<Resource>>(); 
	                
	            	Layer0 L0 = Layer0.getInstance(source);
	                for(Resource child : source.getObjects(inputResource, L0.ConsistsOf)) {
	                    
	                    for(Resource type : source.getObjects(child, L0.InstanceOf)) {
	                        Collection<Resource> coll = index.get(type);
	                        if(coll == null) {
	                            coll = new ArrayList<Resource>();
	                            index.put(type, coll);
	                        }
	                        coll.add(child);
	                    }
	                    
	                }
	
	                NodeContext[] resultContexts = new NodeContext[index.size()];
	                int index2 = 0;
	                for(Map.Entry<Resource, Collection<Resource>> e : index.entrySet()) {
	                    Resource type = e.getKey();
	                    String rep = source.adapt(type, String.class);
	                    resultContexts[index2++] = NodeContextBuilder.buildWithInput(new TypeIndex(type, e.getValue(), rep));
	                }
	                result.setChildren(provider, resultContexts);
	                result.setHasChildren(resultContexts.length > 0);
	
	                provider.scheduleReplace(context, key, result);

            	} catch (DatabaseException e) {
            		e.printStackTrace();
            	}
	                
            }
            
        });
        
        return result;
    }
    
    @Override
    public String toString() {
        return "Structure by types";
    }
    
}
