/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public class RelationContextLabelerFactory implements LabelerFactory {

    @Override
    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, LabelerKey key) {
        assert(updater != null);
        assert(context != null);

        return new LazyGraphLabeler(updater, context, key) {
            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                final RelationContext ctx = (RelationContext) context.getConstant(BuiltinKeys.INPUT);
                String property = LabelerUtil.safeStringRepresentation(graph, ctx.getStatement().getPredicate());
                //System.out.println(getClass().getName() + ": relation context: " + NameUtils.getSafeName(graph, ctx.getSubject()) + " - " + NameUtils.toString(graph, ctx.getStatement()));
                String object = graph.getPossibleRelatedAdapter(ctx.getSubject(), ctx.getStatement().getPredicate(), String.class);
                if (object == null)
                    object = LabelerUtil.safeStringRepresentation(graph, ctx.getStatement().getObject());
                return ArrayMap.make(ColumnKeys.KEYS_PROPERTY_VALUE, new String[] { property, object });
            }
        };
    }

}
