/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.labelers.LabelerContent;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.graph.impl.request.ParametrizedResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.datastructures.Callback;

/**
 * A version of LazyLabeler that uses a set of arbitrary parameters to describe
 * the label resource query within the class.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see LazyGraphLabeler a non-parametrized version (more light-weight)
 */
public abstract class LazyParametrizedGraphLabeler extends LabelerStub {

    private final ParametrizedResourceQuery<LabelerContent> labelQuery;
    private final Listener<LabelerContent>     labelProcedure;
    private final PrimitiveQueryUpdater                     updater;

    // DEBUG
    static int debugCounter = 0;

    public LazyParametrizedGraphLabeler(final PrimitiveQueryUpdater updater, final NodeContext context, final BuiltinKeys.LabelerKey key, Object... parameters) {
        this.updater = updater;
        this.labelQuery = new ParametrizedResourceQuery<LabelerContent>(getClass(), context, parameters) {
            @Override
            public LabelerContent perform(ReadGraph graph) throws DatabaseException {
                return new LabelerContent(category(graph), labels(graph));
            }

        };
        this.labelProcedure = new Listener<LabelerContent>() {

            @Override
            public void execute(LabelerContent result) {
                setContent(result);
                updater.scheduleReplace(context, key, LazyParametrizedGraphLabeler.this);
            }

            @Override
            public void exception(Throwable t) {
                t.printStackTrace();
            }

            @Override
            public boolean isDisposed() {
                return updater.isDisposed();
            }

        };
    }

    @Override
    public Map<String, String> getLabels() {
//        new Exception().printStackTrace();
        if (content == LabelerContent.NO_CONTENT) {
            final DataSource<ReadGraph> source = updater.getDataSource(ReadGraph.class);

            source.schedule(new Callback<ReadGraph>() {
                @Override
                public void run(ReadGraph source) {
//                    try {
                    try {
                        source.syncRequest(labelQuery, labelProcedure);
                    } catch (DatabaseException e) {
                        e.printStackTrace();
                    }
//                } catch (GraphRequestException e) {
//                    e.printStackTrace();
//                }
                }
            });
        }

        return content.labels;
    }

    // OVERRIDE

    public abstract Map<String, String> labels(ReadGraph graph) throws DatabaseException;

    public int category(ReadGraph graph) {
        return content.category;
    }

}
