/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Map;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public abstract class GraphLabelerFactory implements LabelerFactory {

    @Override
    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, LabelerKey key) {

        assert(updater != null);
        assert(context != null);

        return new LazyGraphLabeler(updater, context, key) {
            @Override
            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                return GraphLabelerFactory.this.labels(graph, (Resource) context.getConstant(BuiltinKeys.INPUT));
            }

            @Override
            public int category(ReadGraph graph) throws DatabaseException {
                return GraphLabelerFactory.this.category(graph, (Resource) context.getConstant(BuiltinKeys.INPUT));
            }
            
            @Override
            public String toString() {
            	return GraphLabelerFactory.this.toString();
            }
            
            @Override
            public Modifier getModifier(ModificationContext modificationContext, String key) {
            	return GraphLabelerFactory.this.getModifier(key);
            }
            
        };
    }

    abstract protected Map<String, String> labels(ReadGraph graph, Resource resource) throws DatabaseException;
    
    protected int category(ReadGraph graph, Resource resource) throws DatabaseException {
    	return 0;
    }

    protected Modifier getModifier(String key) {
    	return null;
    }
    
}
