/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.application.arguments;

import org.simantics.application.arguments.IArgumentFactory.IntegerArgumentFactory;
import org.simantics.application.arguments.IArgumentFactory.NoValueArgumentFactory;
import org.simantics.application.arguments.IArgumentFactory.StringArgumentFactory;

public final class SimanticsArguments {

    /**
     * See SimanticsPlatform#RecoveryPolicy.
     */
    public static final IArgumentFactory<Boolean> DO_NOT_SYNCHRONIZE_ONTOLOGIES = new NoValueArgumentFactory("-doNotSynchronizeOntologies");

    /**
     * See SimanticsPlatform#RecoveryPolicy.
     */
    public static final IArgumentFactory<Boolean> RECOVERY_POLICY_FIX_ERRORS = new NoValueArgumentFactory("-fixerrors");

    /**
     * See SimanticsPlatform#OntologyRecoveryPolicy.
     */
    public static final IArgumentFactory<Boolean> ONTOLOGY_RECOVERY_POLICY_REINSTALL = new NoValueArgumentFactory("-reinstall");

    /**
     * An optional argument that forces the default initial value of the
     * workspace shown by the workspace selector to be the location specified
     * with this argument.
     */
    public static final IArgumentFactory<String> DEFAULT_WORKSPACE_LOCATION = new StringArgumentFactory("-defaultWorkspaceLocation");

    /**
     * An optional argument that forces the workspace selector to be brought up
     * during startup of the workbench. Needs no extra arguments. To select the
     * workspace location directly, use the standard Eclipse -data argument.
     */
    public static final IArgumentFactory<Boolean> WORKSPACE_CHOOSER = new NoValueArgumentFactory("-workspacechooser");

    /**
     * An optional argument that forces the workspace selector to be brought up
     * during startup of the workbench. Needs no extra arguments. To select the
     * workspace location directly, use the standard Eclipse -data argument.
     */
    public static final IArgumentFactory<Boolean> WORKSPACE_NO_REMEMBER = new NoValueArgumentFactory("-workspacenoremember");

    /**
     * A mandatory argument because this will be used as the initial perspective
     * of the workbench. The next argument string should be the perspective id.
     */
    public static final IArgumentFactory<String> PERSPECTIVE = new StringArgumentFactory("-perspective");

    /**
     * The address of the ProCore server to connect to for getting the model.
     * The address argument must be written in the form:
     * <code>hostname:port</code>.
     */
    public static final IArgumentFactory<String> SERVER = new StringArgumentFactory("-server", AddressValidator.INSTANCE);

    /**
     * For specifying the port to be used for a new local server. Only effective
     * when a new database is being initialized, i.e. when a new local workspace
     * is initialized.
     */
    public static final IArgumentFactory<Integer> LOCAL_SERVER_PORT = new IntegerArgumentFactory("-localport", 1, 65535);

    /**
     * Indicates that a working copy server is to be initialized from the
     * database server designated by the #SERVER argument.
     */
    public static final IArgumentFactory<Boolean> CHECKOUT = new NoValueArgumentFactory("-checkout");

    /**
     * Tells the system to create a new model in the specified project.
     */
    public static final IArgumentFactory<Boolean> NEW_MODEL = new NoValueArgumentFactory("-newmodel");

    /**
     * The experiment id of the specified model.
     */
    public static final IArgumentFactory<String> EXPERIMENT = new StringArgumentFactory("-experiment");

}
