package org.simantics.db.build;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator extends Plugin {

    public static final String PLUGIN_ID = "org.simantics.db.build";
    static Activator activator;

    @Override
    public void start(BundleContext context) throws Exception {
        activator = this;
        super.start(context);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        activator = null;
    }

    public static Activator get() {
        return activator;
    }

    private static final String ROOT = "/";

    public static File getRoot()
    throws FileNotFoundException, IOException {
        Bundle b = Activator.get().getBundle();
        URL source = FileLocator.find(b, new Path(ROOT), null);
        URL fileSource = FileLocator.toFileURL(source);
        if (fileSource == source)
            throw new FileNotFoundException(ROOT + "could not be made available from bundle " + b.getSymbolicName());
        File root = new File(fileSource.getFile());
        return root;
    }
}
